/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.decoration;

import com.google.common.collect.Streams;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.collections4.iterators.NodeListIterator;
import org.apache.commons.lang3.StringUtils;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.ServiceException;
import org.geoserver.platform.resource.Resource;
import org.geoserver.wms.WMSMapContent;
import org.geoserver.wms.decoration.MapDecoration;
import org.geoserver.wms.decoration.MetatiledMapDecorationLayout;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.filter.text.ecql.ECQL;
import org.geotools.util.logging.Logging;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class MapDecorationLayout {
    public static final FilterFactory2 FF = CommonFactoryFinder.getFilterFactory2();
    private static final Pattern EXPRESSION = Pattern.compile("^\\s*\\$\\{(.*)\\}\\s*$");
    private static Logger LOGGER = Logging.getLogger(MapDecorationLayout.class);
    List<Block> blocks = new ArrayList<Block>();

    public static MapDecorationLayout fromFile(Resource f, boolean tiled) throws Exception {
        Document confFile;
        MapDecorationLayout dl = tiled ? new MetatiledMapDecorationLayout() : new MapDecorationLayout();
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        try (InputStream in = f.in();){
            confFile = builder.parse(in);
        }
        return MapDecorationLayout.fromDocument(dl, confFile);
    }

    public static MapDecorationLayout fromString(String definition, boolean tiled) throws Exception {
        MapDecorationLayout dl = tiled ? new MetatiledMapDecorationLayout() : new MapDecorationLayout();
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        InputSource source = new InputSource(new StringReader(definition));
        Document confFile = builder.parse(source);
        return MapDecorationLayout.fromDocument(dl, confFile);
    }

    private static Iterator<Element> getChildren(Element parent, String childName) {
        NodeListIterator iterator = new NodeListIterator((Node)parent);
        return Streams.stream((Iterator)iterator).filter(Element.class::isInstance).filter(e -> childName.equals(e.getNodeName())).map(Element.class::cast).iterator();
    }

    private static MapDecorationLayout fromDocument(MapDecorationLayout dl, Document confFile) throws Exception {
        Iterator<Element> decorations = MapDecorationLayout.getChildren(confFile.getDocumentElement(), "decoration");
        while (decorations.hasNext()) {
            Point offset;
            Element e = decorations.next();
            HashMap<String, Expression> m = new HashMap<String, Expression>();
            String decorationType = e.getAttribute("type");
            Iterator<Element> options = MapDecorationLayout.getChildren(e, "option");
            while (options.hasNext()) {
                Element option = options.next();
                String name = option.getAttribute("name");
                String value = option.getAttribute("value");
                if (value == null || value.isEmpty()) {
                    value = option.getTextContent();
                }
                if (value == null) continue;
                Object expression = MapDecorationLayout.isTextMessage(name, decorationType) ? FF.literal((Object)value) : MapDecorationLayout.parseExpression(value);
                m.put(name, (Expression)expression);
            }
            MapDecoration decoration = MapDecorationLayout.getDecoration(decorationType);
            if (decoration == null) {
                LOGGER.log(Level.WARNING, "Unknown decoration type: " + decorationType + " requested.");
                continue;
            }
            decoration.loadOptions(m);
            Block.Position pos = Block.Position.fromString(MapDecorationLayout.evaluateAttribute(e, "affinity"));
            if (pos == null) {
                LOGGER.log(Level.WARNING, "Unknown affinity: " + e.getAttribute("affinity") + " requested.");
                continue;
            }
            Dimension size = null;
            String theSize = MapDecorationLayout.evaluateAttribute(e, "size");
            try {
                if (!StringUtils.isEmpty((CharSequence)theSize) && !theSize.equalsIgnoreCase("auto")) {
                    String[] sizeArr = theSize.split(",");
                    size = new Dimension(Integer.valueOf(sizeArr[0]), Integer.valueOf(sizeArr[1]));
                }
            }
            catch (Exception exc) {
                LOGGER.log(Level.WARNING, "Couldn't interpret size parameter: " + theSize, e);
            }
            String theOffset = MapDecorationLayout.evaluateAttribute(e, "offset");
            try {
                if (!StringUtils.isEmpty((CharSequence)theOffset)) {
                    String[] offsetArr = theOffset.split(",");
                    offset = new Point(Integer.valueOf(offsetArr[0]), Integer.valueOf(offsetArr[1]));
                } else {
                    offset = new Point(0, 0);
                }
            }
            catch (Exception exc) {
                LOGGER.log(Level.WARNING, "Couldn't interpret offset parameter: " + theOffset, e);
                offset = new Point(0, 0);
            }
            dl.addBlock(new Block(decoration, pos, size, offset));
        }
        return dl;
    }

    private static String evaluateAttribute(Element e, String name) throws CQLException {
        String attribute = e.getAttribute(name);
        if (attribute == null) {
            return null;
        }
        return (String)MapDecorationLayout.parseExpression(attribute).evaluate(null, String.class);
    }

    private static Expression parseExpression(String value) throws CQLException {
        Matcher matcher = EXPRESSION.matcher(value);
        Object expression = matcher.matches() ? ECQL.toExpression((String)matcher.group(1)) : FF.literal((Object)value);
        return expression;
    }

    private static boolean isTextMessage(String name, String decorationType) {
        return "message".equals(name) && "text".equals(decorationType);
    }

    public void addBlock(Block b) {
        this.blocks.add(b);
    }

    public void paint(Graphics2D g2d, Rectangle paintArea, WMSMapContent mapContent) {
        for (Block b : this.blocks) {
            try {
                this.resetGraphics(g2d);
                b.paint(g2d, paintArea, mapContent);
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "couldn't paint due to: ", e);
            }
        }
    }

    private void resetGraphics(Graphics2D g2d) {
        g2d.setComposite(AlphaComposite.SrcOver);
        g2d.setColor(Color.WHITE);
        g2d.setBackground(Color.BLACK);
        g2d.setClip(null);
        g2d.setPaint(Color.WHITE);
        g2d.setStroke(new BasicStroke());
    }

    private static MapDecoration getDecoration(String name) {
        Object o = GeoServerExtensions.bean((String)name);
        if (o instanceof MapDecoration) {
            return (MapDecoration)o;
        }
        return null;
    }

    public boolean isEmpty() {
        return this.blocks.isEmpty();
    }

    public static Color parseColor(String origInput) {
        if (origInput == null) {
            return null;
        }
        String input = origInput.trim();
        input = input.replaceFirst("\\A#", "");
        switch (input.length()) {
            case 1: 
            case 2: {
                return new Color(Integer.valueOf(input, 16));
            }
            case 3: {
                int r = Integer.valueOf(input.substring(0, 1), 16);
                int g = Integer.valueOf(input.substring(1, 2), 16);
                int b = Integer.valueOf(input.substring(2, 3), 16);
                return new Color(r, g, b);
            }
            case 4: {
                int r = Integer.valueOf(input.substring(0, 1), 16);
                int g = Integer.valueOf(input.substring(1, 2), 16);
                int b = Integer.valueOf(input.substring(2, 3), 16);
                int a = Integer.valueOf(input.substring(3, 4), 16);
                return new Color(r, g, b, a);
            }
            case 6: {
                int r = Integer.valueOf(input.substring(0, 2), 16);
                int g = Integer.valueOf(input.substring(2, 4), 16);
                int b = Integer.valueOf(input.substring(4, 6), 16);
                return new Color(r, g, b);
            }
            case 8: {
                int r = Integer.valueOf(input.substring(0, 2), 16);
                int g = Integer.valueOf(input.substring(2, 4), 16);
                int b = Integer.valueOf(input.substring(4, 6), 16);
                int a = Integer.valueOf(input.substring(6, 8), 16);
                return new Color(r, g, b, a);
            }
        }
        throw new RuntimeException("Couldn't decode color value: " + origInput + " (" + input + ")");
    }

    static String getOption(Map<String, Expression> options, String key) {
        return MapDecorationLayout.getOption(options, key, String.class);
    }

    static <T> T getOption(Map<String, Expression> options, String key, Class<T> target) {
        if (options == null) {
            return null;
        }
        Expression expression = options.get(key);
        return MapDecorationLayout.evaluate(expression, target);
    }

    static <T> T evaluate(Expression expression, Class<T> target) {
        if (expression == null) {
            return null;
        }
        Object result = expression.evaluate(null, target);
        if (result == null && expression != null) {
            throw new IllegalArgumentException("Could not convert " + expression + " to " + target.getSimpleName());
        }
        return (T)result;
    }

    public static class Block {
        final MapDecoration decoration;
        final Position position;
        final Dimension dimension;
        final Point offset;

        public static Rectangle findBounds(Position p, Rectangle container, Dimension dim, Point o) {
            if (p == null || container == null || dim == null || o == null) {
                throw new ServiceException("Bad params for decoration sizing.");
            }
            int x = 0;
            int y = 0;
            int height = dim.height;
            int width = dim.width;
            switch (p) {
                case UC: 
                case UR: 
                case UL: {
                    y = (int)(container.getMinY() + (double)o.y);
                    break;
                }
                case CL: 
                case CC: 
                case CR: {
                    y = (int)(container.getMinY() + container.getMaxY() - (double)dim.height) / 2;
                    break;
                }
                case LL: 
                case LC: 
                case LR: {
                    y = (int)(container.getMaxY() - (double)o.y - (double)dim.height);
                }
            }
            switch (p) {
                case UL: 
                case CL: 
                case LL: {
                    x = (int)(container.getMinX() + (double)o.x);
                    break;
                }
                case UC: 
                case CC: 
                case LC: {
                    x = (int)(container.getMinX() + container.getMaxX() - dim.getWidth()) / 2;
                    break;
                }
                case UR: 
                case CR: 
                case LR: {
                    x = (int)(container.getMaxX() - (double)o.x - (double)dim.width);
                }
            }
            if (dim.width + 2 * o.x > container.width) {
                x = (int)container.getMinX() + o.x;
                width = container.width - 2 * o.x;
            }
            if (dim.height + 2 * o.y > container.height) {
                y = (int)container.getMinY() + o.y;
                height = container.height - 2 * o.y;
            }
            return new Rectangle(x, y, width, height);
        }

        public Block(MapDecoration d, Position p, Dimension dim, Point o) {
            this.decoration = d;
            this.position = p;
            this.dimension = dim;
            this.offset = o;
        }

        public Dimension findOptimalSize(Graphics2D g2d, WMSMapContent mapContent) throws Exception {
            return this.dimension != null ? this.dimension : this.decoration.findOptimalSize(g2d, mapContent);
        }

        public void paint(Graphics2D g2d, Rectangle rect, WMSMapContent mapContent) throws Exception {
            Dimension desiredSize = this.findOptimalSize(g2d, mapContent);
            Rectangle box = Block.findBounds(this.position, rect, desiredSize, this.offset);
            Shape oldClip = g2d.getClip();
            g2d.setClip(box);
            this.decoration.paint(g2d, box, mapContent);
            g2d.setClip(oldClip);
        }

        public static enum Position {
            UL("top,left"),
            UC("top,center"),
            UR("top,right"),
            CL("center,left"),
            CC("center,center"),
            CR("center,right"),
            LL("bottom,left"),
            LC("bottom,center"),
            LR("bottom,right");

            private final String name;

            private Position(String name) {
                this.name = name;
            }

            public static Position fromString(String str) {
                for (Position p : Position.values()) {
                    if (!p.name.equalsIgnoreCase(str)) continue;
                    return p;
                }
                return null;
            }
        }
    }
}

