/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.clip;

import java.awt.RenderingHints;
import java.awt.Shape;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.security.decorators.DecoratingGridCoverage2DReader;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.coverage.processing.CoverageProcessor;
import org.geotools.coverage.processing.operation.Crop;
import org.geotools.data.ResourceInfo;
import org.geotools.data.ServiceInfo;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.jts.JTS;
import org.geotools.image.ImageWorker;
import org.geotools.referencing.CRS;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Geometry;
import org.opengis.geometry.Envelope;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;

public class CroppedGridCoverage2DReader
extends DecoratingGridCoverage2DReader {
    private static final ParameterValueGroup cropParams;
    static final Logger LOGGER;
    private static final Crop coverageCropFactory;
    Geometry roiGeom;

    public CroppedGridCoverage2DReader(GridCoverage2DReader delegate, Geometry roiGeom) {
        super(delegate);
        this.roiGeom = this.reproject(delegate.getCoordinateReferenceSystem(), roiGeom);
    }

    private Geometry reproject(CoordinateReferenceSystem gridCRS, Geometry clipGeom) {
        try {
            CoordinateReferenceSystem geomCRS = CRS.decode((String)("EPSG:" + clipGeom.getSRID()));
            if (CRS.isTransformationRequired((CoordinateReferenceSystem)geomCRS, (CoordinateReferenceSystem)gridCRS)) {
                MathTransform mt = CRS.findMathTransform((CoordinateReferenceSystem)geomCRS, (CoordinateReferenceSystem)gridCRS);
                clipGeom = JTS.transform((Geometry)clipGeom, (MathTransform)mt);
                clipGeom.setSRID(CRS.lookupEpsgCode((CoordinateReferenceSystem)gridCRS, (boolean)false).intValue());
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "failed to reproject " + clipGeom.toText());
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
        }
        return clipGeom;
    }

    public ServiceInfo getInfo() {
        return this.delegate.getInfo();
    }

    public ResourceInfo getInfo(String coverageName) {
        return this.delegate.getInfo(coverageName);
    }

    public GridCoverage2D read(GeneralParameterValue[] parameters) throws IllegalArgumentException, IOException {
        return CroppedGridCoverage2DReader.getCroppedGrid(super.read(parameters), this.roiGeom);
    }

    public GridCoverage2D read(String coverageName, GeneralParameterValue[] parameters) throws IllegalArgumentException, IOException {
        return CroppedGridCoverage2DReader.getCroppedGrid(super.read(coverageName, parameters), this.roiGeom);
    }

    public GeneralEnvelope getOriginalEnvelope() {
        GeneralEnvelope originalEnvelope = super.getOriginalEnvelope();
        try {
            Geometry envIntersection = this.roiGeom.intersection(JTS.toGeometry((Shape)originalEnvelope.toRectangle2D()));
            envIntersection.setSRID(CRS.lookupEpsgCode((CoordinateReferenceSystem)originalEnvelope.getCoordinateReferenceSystem(), (boolean)false).intValue());
            return GeneralEnvelope.toGeneralEnvelope((Envelope)JTS.toEnvelope((Geometry)envIntersection));
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
            return originalEnvelope;
        }
    }

    private static synchronized GridCoverage2D getCroppedGrid(GridCoverage2D grid, Geometry clipGeom) {
        ParameterValueGroup param = cropParams.clone();
        param.parameter("source").setValue((Object)grid);
        param.parameter("ROI").setValue((Object)clipGeom);
        Hints hints = new Hints((RenderingHints.Key)ImageWorker.FORCE_MOSAIC_ROI_PROPERTY, (Object)true);
        return (GridCoverage2D)coverageCropFactory.doOperation(param, hints);
    }

    static {
        LOGGER = Logging.getLogger((String)CroppedGridCoverage2DReader.class.getCanonicalName());
        CoverageProcessor processor = new CoverageProcessor((RenderingHints)new Hints((RenderingHints.Key)Hints.LENIENT_DATUM_SHIFT, (Object)Boolean.TRUE));
        cropParams = processor.getOperation("CoverageCrop").getParameters();
        coverageCropFactory = new Crop();
    }
}

