/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.clip;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.security.decorators.DecoratingFeatureSource;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.process.vector.ClipProcess;
import org.geotools.referencing.CRS;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.Feature;
import org.opengis.feature.type.FeatureType;
import org.opengis.filter.Filter;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;

public class ClippedFeatureSource<T extends FeatureType, F extends Feature>
extends DecoratingFeatureSource<T, F> {
    static final Logger LOGGER = Logging.getLogger(ClippedFeatureSource.class);
    Geometry clip;

    public ClippedFeatureSource(FeatureSource<T, F> delegate, Geometry clipGeometry) {
        super(delegate);
        this.clip = this.reproject(delegate.getInfo().getCRS(), clipGeometry);
    }

    private Geometry reproject(CoordinateReferenceSystem fsCRS, Geometry clipGeom) {
        try {
            CoordinateReferenceSystem geomCRS = CRS.decode((String)("EPSG:" + clipGeom.getSRID()));
            if (CRS.isTransformationRequired((CoordinateReferenceSystem)geomCRS, (CoordinateReferenceSystem)fsCRS)) {
                MathTransform mt = CRS.findMathTransform((CoordinateReferenceSystem)geomCRS, (CoordinateReferenceSystem)fsCRS);
                clipGeom = JTS.transform((Geometry)clipGeom, (MathTransform)mt);
                clipGeom.setSRID(CRS.lookupEpsgCode((CoordinateReferenceSystem)fsCRS, (boolean)false).intValue());
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "failed to reproject " + clipGeom.toText());
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
        }
        return clipGeom;
    }

    public ReferencedEnvelope getBounds() throws IOException {
        ReferencedEnvelope orignalBounds = super.getBounds();
        return JTS.toEnvelope((Geometry)this.clip.intersection((Geometry)JTS.toGeometry((ReferencedEnvelope)orignalBounds)));
    }

    public ReferencedEnvelope getBounds(Query query) throws IOException {
        return this.getFeatures(query).getBounds();
    }

    public int getCount(Query query) throws IOException {
        return this.getFeatures(query).size();
    }

    public FeatureCollection<T, F> getFeatures() throws IOException {
        return this.getClippedCollection(super.getFeatures(), this.clip);
    }

    public FeatureCollection<T, F> getFeatures(Filter filter) throws IOException {
        return this.getClippedCollection(super.getFeatures(filter), this.clip);
    }

    public FeatureCollection<T, F> getFeatures(Query query) throws IOException {
        return this.getClippedCollection(super.getFeatures(query), this.clip);
    }

    private FeatureCollection<T, F> getClippedCollection(FeatureCollection<T, F> fc, Geometry clipGeom) {
        if (fc instanceof SimpleFeatureCollection) {
            return new ClipProcess().execute((SimpleFeatureCollection)fc, clipGeom, Boolean.valueOf(false));
        }
        return fc;
    }
}

