/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.clip;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.collection.DecoratingFeatureCollection;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.process.vector.ClipProcess;
import org.geotools.referencing.CRS;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.Feature;
import org.opengis.feature.type.FeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;

public class ClippedFeatureCollection<T extends FeatureType, F extends Feature>
extends DecoratingFeatureCollection<T, F> {
    static final Logger LOGGER = Logging.getLogger(ClippedFeatureCollection.class);
    Geometry clip;

    public ClippedFeatureCollection(FeatureCollection<T, F> delegate, Geometry clipGeometry) {
        super(delegate);
        this.clip = this.reproject(delegate.getSchema().getCoordinateReferenceSystem(), clipGeometry);
    }

    private Geometry reproject(CoordinateReferenceSystem fsCRS, Geometry clipGeom) {
        try {
            CoordinateReferenceSystem geomCRS = CRS.decode((String)("EPSG:" + clipGeom.getSRID()));
            if (CRS.isTransformationRequired((CoordinateReferenceSystem)geomCRS, (CoordinateReferenceSystem)fsCRS)) {
                MathTransform mt = CRS.findMathTransform((CoordinateReferenceSystem)geomCRS, (CoordinateReferenceSystem)fsCRS);
                clipGeom = JTS.transform((Geometry)clipGeom, (MathTransform)mt);
                clipGeom.setSRID(CRS.lookupEpsgCode((CoordinateReferenceSystem)fsCRS, (boolean)false).intValue());
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "failed to reproject " + clipGeom.toText());
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
        }
        return clipGeom;
    }

    public FeatureIterator<F> features() {
        return this.getClippedCollection(this.delegate, this.clip);
    }

    public ReferencedEnvelope getBounds() {
        ReferencedEnvelope orignalBounds = super.getBounds();
        return JTS.toEnvelope((Geometry)this.clip.intersection((Geometry)JTS.toGeometry((ReferencedEnvelope)orignalBounds)));
    }

    private FeatureIterator<F> getClippedCollection(FeatureCollection<T, F> fc, Geometry clipGeom) {
        if (fc instanceof SimpleFeatureCollection) {
            return new ClipProcess().execute((SimpleFeatureCollection)fc, clipGeom, Boolean.valueOf(false)).features();
        }
        return fc.features();
    }
}

