/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.clip;

import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.apache.commons.beanutils.BeanUtilsBean2;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.CachedGridReaderLayer;
import org.geoserver.wms.GetMapCallback;
import org.geoserver.wms.GetMapRequest;
import org.geoserver.wms.WMSMapContent;
import org.geoserver.wms.WebMap;
import org.geoserver.wms.clip.ClippedFeatureSource;
import org.geoserver.wms.clip.CroppedGridCoverage2DReader;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.WKTReader2;
import org.geotools.map.FeatureLayer;
import org.geotools.map.GridReaderLayer;
import org.geotools.map.Layer;
import org.geotools.referencing.CRS;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;

public class ClipWMSGetMapCallBack
implements GetMapCallback {
    private static final Logger LOGGER = Logging.getLogger((String)ClipWMSGetMapCallBack.class.getName());
    private static final WKTReader2 reader = new WKTReader2();
    private static final Pattern SRID_REGEX = Pattern.compile("SRID=[0-9].*");

    @Override
    public GetMapRequest initRequest(GetMapRequest request) {
        return request;
    }

    @Override
    public void initMapContent(WMSMapContent mapContent) {
    }

    @Override
    public Layer beforeLayer(WMSMapContent mapContent, Layer layer) {
        Geometry wktGeom = mapContent.getRequest().getClip();
        if (wktGeom == null) {
            return layer;
        }
        Polygon bboxGeom = JTS.toGeometry((Envelope)mapContent.getRequest().getBbox());
        if (wktGeom.covers((Geometry)bboxGeom)) {
            return layer;
        }
        try {
            if (layer instanceof FeatureLayer) {
                FeatureLayer fl = (FeatureLayer)layer;
                ClippedFeatureSource clippedFS = new ClippedFeatureSource(layer.getFeatureSource(), wktGeom);
                FeatureLayer clippedLayer = new FeatureLayer(clippedFS, fl.getStyle(), fl.getTitle());
                BeanUtilsBean2.getInstance().copyProperties((Object)clippedLayer, (Object)fl);
                fl.getUserData().putAll(layer.getUserData());
                return clippedLayer;
            }
            if (layer instanceof GridReaderLayer) {
                GridReaderLayer gr = (GridReaderLayer)layer;
                CroppedGridCoverage2DReader croppedGridReader = new CroppedGridCoverage2DReader(gr.getReader(), wktGeom);
                CachedGridReaderLayer croppedGridLayer = new CachedGridReaderLayer((GridCoverage2DReader)croppedGridReader, layer.getStyle(), ((GridReaderLayer)layer).getParams());
                BeanUtilsBean2.getInstance().copyProperties((Object)croppedGridLayer, (Object)gr);
                croppedGridLayer.getUserData().putAll(layer.getUserData());
                return croppedGridLayer;
            }
        }
        catch (Exception e) {
            LOGGER.severe("Error occurred while clipping layer " + layer.getTitle());
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
            return layer;
        }
        return layer;
    }

    @Override
    public WMSMapContent beforeRender(WMSMapContent mapContent) {
        return mapContent;
    }

    @Override
    public WebMap finished(WebMap map) {
        return map;
    }

    @Override
    public void failed(Throwable t) {
    }

    public static synchronized Geometry readGeometry(String wkt, CoordinateReferenceSystem mapCRS) throws Exception {
        String[] wktContents = wkt.split(";");
        Geometry geom = reader.read(wktContents[wktContents.length - 1]);
        if (!geom.getClass().isAssignableFrom(Polygon.class) && !geom.getClass().isAssignableFrom(MultiPolygon.class)) {
            throw new ServiceException("Clip must be a polygon or multipolygon", "InvalidParameterValue", "clip");
        }
        if (wktContents.length == 2 && SRID_REGEX.matcher(wktContents[0].toUpperCase()).matches()) {
            String sridString = wktContents[0].split("=")[1];
            CoordinateReferenceSystem geomCRS = CRS.decode((String)("EPSG:" + sridString), (boolean)true);
            CoordinateReferenceSystem mapCRSXY = CRS.decode((String)("EPSG:" + CRS.lookupEpsgCode((CoordinateReferenceSystem)mapCRS, (boolean)false)), (boolean)true);
            if (CRS.isTransformationRequired((CoordinateReferenceSystem)mapCRSXY, (CoordinateReferenceSystem)geomCRS)) {
                MathTransform transform = CRS.findMathTransform((CoordinateReferenceSystem)geomCRS, (CoordinateReferenceSystem)mapCRSXY);
                geom = JTS.transform((Geometry)geom, (MathTransform)transform);
            }
        }
        geom.setSRID(CRS.lookupEpsgCode((CoordinateReferenceSystem)mapCRS, (boolean)false).intValue());
        return geom;
    }
}

