/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.capabilities;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.geoserver.catalog.LayerGroupHelper;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.LegendInfo;
import org.geoserver.catalog.PublishedInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.wms.WMS;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.Rule;
import org.geotools.styling.Style;
import org.geotools.util.NumberRange;
import org.xml.sax.helpers.AttributesImpl;

public final class CapabilityUtil {
    public static final String LAYER_GROUP_STYLE_NAME = "default-style";
    protected static final String LAYER_GROUP_STYLE_TITLE_PREFIX = "";
    protected static final String LAYER_GROUP_STYLE_TITLE_SUFFIX = " style";
    protected static final String LAYER_GROUP_STYLE_ABSTRACT_PREFIX = "Default style for ";
    protected static final String LAYER_GROUP_STYLE_ABSTRACT_SUFFIX = " layer";

    private CapabilityUtil() {
    }

    public static NumberRange<Double> searchMinMaxScaleDenominator(Set<StyleInfo> styles) throws IOException {
        double minScaleDenominator = Double.POSITIVE_INFINITY;
        double maxScaleDenominator = Double.NEGATIVE_INFINITY;
        for (StyleInfo styleInfo : styles) {
            Style style = styleInfo.getStyle();
            for (FeatureTypeStyle fts : style.featureTypeStyles()) {
                for (Rule rule : fts.rules()) {
                    if (rule.getMinScaleDenominator() < minScaleDenominator) {
                        minScaleDenominator = rule.getMinScaleDenominator();
                    }
                    if (!(rule.getMaxScaleDenominator() > maxScaleDenominator)) continue;
                    maxScaleDenominator = rule.getMaxScaleDenominator();
                }
            }
        }
        if (minScaleDenominator == Double.POSITIVE_INFINITY) {
            minScaleDenominator = 0.0;
        }
        if (maxScaleDenominator == Double.NEGATIVE_INFINITY) {
            maxScaleDenominator = Double.POSITIVE_INFINITY;
        }
        assert (minScaleDenominator <= maxScaleDenominator) : "Min <= Max scale is expected";
        return new NumberRange(Double.class, (Number)minScaleDenominator, (Number)maxScaleDenominator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NumberRange<Double> searchMinMaxScaleDenominator(LayerInfo layer) throws IOException {
        StyleInfo defaultStyle;
        HashSet<StyleInfo> stylesCopy;
        LayerInfo layerInfo = layer;
        synchronized (layerInfo) {
            stylesCopy = new HashSet<StyleInfo>(layer.getStyles());
            defaultStyle = layer.getDefaultStyle();
        }
        if (!stylesCopy.contains(defaultStyle)) {
            stylesCopy.add(defaultStyle);
        }
        return CapabilityUtil.searchMinMaxScaleDenominator(stylesCopy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void findLayerGroupStyles(LayerGroupInfo layerGroup, Set<StyleInfo> stylesCopy) {
        LayerGroupInfo layerGroupInfo = layerGroup;
        synchronized (layerGroupInfo) {
            for (int i = 0; i < layerGroup.getLayers().size(); ++i) {
                StyleInfo styleInfo = (StyleInfo)layerGroup.getStyles().get(i);
                if (styleInfo == null) {
                    PublishedInfo publishedInfo = (PublishedInfo)layerGroup.getLayers().get(i);
                    if (publishedInfo instanceof LayerInfo) {
                        styleInfo = ((LayerInfo)publishedInfo).getDefaultStyle();
                        stylesCopy.add(styleInfo);
                        continue;
                    }
                    if (!(publishedInfo instanceof LayerGroupInfo)) continue;
                    CapabilityUtil.findLayerGroupStyles((LayerGroupInfo)publishedInfo, stylesCopy);
                    continue;
                }
                stylesCopy.add(styleInfo);
            }
        }
    }

    public static NumberRange<Double> searchMinMaxScaleDenominator(LayerGroupInfo layerGroup) throws IOException {
        HashSet<StyleInfo> stylesCopy = new HashSet<StyleInfo>();
        CapabilityUtil.findLayerGroupStyles(layerGroup, stylesCopy);
        return CapabilityUtil.searchMinMaxScaleDenominator(stylesCopy);
    }

    public static NumberRange<Double> searchMinMaxScaleDenominator(PublishedInfo publishedInfo) throws IOException {
        if (publishedInfo instanceof LayerInfo) {
            return CapabilityUtil.searchMinMaxScaleDenominator((LayerInfo)publishedInfo);
        }
        if (publishedInfo instanceof LayerGroupInfo) {
            return CapabilityUtil.searchMinMaxScaleDenominator((LayerGroupInfo)publishedInfo);
        }
        throw new UnsupportedOperationException("PublishedInfo must be either Layer or Layergroup");
    }

    public static Double computeScaleHint(Double scaleDenominator) {
        Double sizeStandardRenderPixel = 2.8E-4;
        Double scaleHint = Math.sqrt(Math.pow(scaleDenominator * sizeStandardRenderPixel, 2.0) * 2.0);
        return scaleHint;
    }

    public static boolean validateLegendInfo(LegendInfo legend) {
        return legend != null && legend.getOnlineResource() != null && legend.getHeight() > 0 && legend.getWidth() > 0;
    }

    public static AttributesImpl addGetLegendAttributes(AttributesImpl attrs, String legendURL, String XLINK_NS) {
        attrs.addAttribute(LAYER_GROUP_STYLE_TITLE_PREFIX, "xmlns:xlink", "xmlns:xlink", LAYER_GROUP_STYLE_TITLE_PREFIX, XLINK_NS);
        attrs.addAttribute(XLINK_NS, "type", "xlink:type", LAYER_GROUP_STYLE_TITLE_PREFIX, "simple");
        attrs.addAttribute(XLINK_NS, "href", "xlink:href", LAYER_GROUP_STYLE_TITLE_PREFIX, legendURL);
        return attrs;
    }

    public static boolean encodeGroupDefaultStyle(WMS wms, LayerGroupInfo lgi) {
        boolean opaqueOrSingle = LayerGroupHelper.isSingleOrOpaque((LayerGroupInfo)lgi);
        return opaqueOrSingle || wms.isDefaultGroupStyleEnabled();
    }

    public static String getGroupDefaultStyleName(String groupName) {
        return LAYER_GROUP_STYLE_NAME.concat("-").concat(groupName);
    }

    public static String getGroupDefaultStyleName(LayerGroupInfo groupName) {
        return CapabilityUtil.getGroupDefaultStyleName(groupName.prefixedName());
    }
}

