/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms;

import java.awt.Color;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.IndexColorModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.GetMapCallback;
import org.geoserver.wms.GetMapRequest;
import org.geoserver.wms.ScaleComputationMethod;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.Layer;
import org.geotools.map.MapContent;
import org.geotools.referencing.operation.matrix.XAffineTransform;
import org.geotools.renderer.lite.RendererUtilities;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class WMSMapContent
extends MapContent {
    private int mapWidth;
    private int mapHeight;
    private Color bgColor = Color.white;
    private boolean transparent;
    private int tileSize = -1;
    private double angle;
    private List<GetMapCallback> callbacks;
    private Map<String, Object> metadata = new HashMap<String, Object>();
    private int buffer;
    private IndexColorModel icm;
    private GetMapRequest request;

    public int getTileSize() {
        return this.tileSize;
    }

    public void setTileSize(int tileSize) {
        this.tileSize = tileSize;
    }

    public WMSMapContent() {
    }

    public WMSMapContent(GetMapRequest req) {
        this.request = req;
    }

    public WMSMapContent(WMSMapContent other, boolean copyLayers) {
        this.mapWidth = other.mapWidth;
        this.mapHeight = other.mapHeight;
        this.bgColor = other.bgColor;
        this.transparent = other.transparent;
        this.tileSize = other.tileSize;
        this.angle = other.angle;
        this.callbacks = new ArrayList<GetMapCallback>(other.callbacks);
        this.buffer = other.buffer;
        this.icm = other.icm;
        this.request = other.request;
        if (copyLayers) {
            this.layers().addAll(other.layers());
        }
        this.getViewport().setBounds(other.getViewport().getBounds());
    }

    public Color getBgColor() {
        return this.bgColor;
    }

    public void setBgColor(Color bgColor) {
        this.bgColor = bgColor;
    }

    public int getMapHeight() {
        return this.mapHeight;
    }

    public void setMapHeight(int mapHeight) {
        this.mapHeight = mapHeight;
    }

    public int getMapWidth() {
        return this.mapWidth;
    }

    public void setMapWidth(int mapWidth) {
        this.mapWidth = mapWidth;
    }

    public boolean isTransparent() {
        return this.transparent;
    }

    public void setTransparent(boolean transparent) {
        this.transparent = transparent;
    }

    public GetMapRequest getRequest() {
        return this.request;
    }

    public void setRequest(GetMapRequest request) {
        this.request = request;
    }

    public int getBuffer() {
        return this.buffer;
    }

    public void setBuffer(int buffer) {
        this.buffer = buffer;
    }

    public IndexColorModel getPalette() {
        return this.icm;
    }

    public void setPalette(IndexColorModel paletteInverter) {
        this.icm = paletteInverter;
    }

    public double getAngle() {
        return this.angle;
    }

    public void setAngle(double rotation) {
        this.angle = rotation;
    }

    public boolean addLayer(Layer layer) {
        if ((layer = this.fireLayerCallbacks(layer)) != null) {
            return super.addLayer(layer);
        }
        return false;
    }

    private Layer fireLayerCallbacks(Layer layer) {
        if (this.callbacks == null) {
            return layer;
        }
        for (GetMapCallback callback : this.callbacks) {
            layer = callback.beforeLayer(this, layer);
            if (layer != null) continue;
            return null;
        }
        return layer;
    }

    public int addLayers(Collection<? extends Layer> layers) {
        ArrayList<Layer> filtered = new ArrayList<Layer>(layers.size());
        for (Layer layer : layers) {
            Layer layer2 = this.fireLayerCallbacks(layer);
            if (layer2 == null) continue;
            filtered.add(layer2);
        }
        if (filtered.isEmpty()) {
            return 0;
        }
        return super.addLayers(filtered);
    }

    public AffineTransform getRenderingTransform() {
        AffineTransform tx;
        Rectangle paintArea = new Rectangle(0, 0, this.getMapWidth(), this.getMapHeight());
        ReferencedEnvelope dataArea = this.getViewport().getBounds();
        if (this.getAngle() != 0.0) {
            tx = new AffineTransform();
            tx.translate(paintArea.width / 2, paintArea.height / 2);
            tx.rotate(Math.toRadians(this.getAngle()));
            tx.translate(-paintArea.width / 2, -paintArea.height / 2);
            tx.concatenate(RendererUtilities.worldToScreenTransform((ReferencedEnvelope)dataArea, (Rectangle)paintArea));
        } else {
            tx = RendererUtilities.worldToScreenTransform((ReferencedEnvelope)dataArea, (Rectangle)paintArea);
        }
        return tx;
    }

    public ReferencedEnvelope getRenderingArea() {
        ReferencedEnvelope dataArea = this.getViewport().getBounds();
        if (this.getAngle() == 0.0) {
            return dataArea;
        }
        AffineTransform tx = new AffineTransform();
        double offsetX = dataArea.getMinX() + dataArea.getWidth() / 2.0;
        double offsetY = dataArea.getMinY() + dataArea.getHeight() / 2.0;
        tx.translate(offsetX, offsetY);
        tx.rotate(Math.toRadians(this.getAngle()));
        tx.translate(-offsetX, -offsetY);
        Rectangle2D.Double dataAreaShape = new Rectangle2D.Double(dataArea.getMinX(), dataArea.getMinY(), dataArea.getWidth(), dataArea.getHeight());
        Rectangle2D transformedBounds = tx.createTransformedShape(dataAreaShape).getBounds2D();
        return new ReferencedEnvelope(transformedBounds, dataArea.getCoordinateReferenceSystem());
    }

    public String getContactInformation() {
        String contact = (String)this.getUserData().get("contact");
        return contact == null ? "" : contact;
    }

    public void setContactInformation(String contactInformation) {
        this.getUserData().put("contact", contactInformation);
    }

    public String[] getKeywords() {
        Object obj = this.getUserData().get("keywords");
        if (obj == null) {
            return new String[0];
        }
        if (obj instanceof String) {
            String keywords = (String)obj;
            return keywords.split(",");
        }
        if (obj instanceof String[]) {
            String[] keywords = (String[])obj;
            String[] copy = new String[keywords.length];
            System.arraycopy(keywords, 0, copy, 0, keywords.length);
            return copy;
        }
        if (obj instanceof Collection) {
            Collection keywords = (Collection)obj;
            return keywords.toArray(new String[keywords.size()]);
        }
        return new String[0];
    }

    public void setKeywords(String[] keywords) {
        this.getUserData().put("keywords", keywords);
    }

    public String getAbstract() {
        String description = (String)this.getUserData().get("abstract");
        return description == null ? "" : description;
    }

    public void setAbstract(String contextAbstract) {
        this.getUserData().put("abstract", contextAbstract);
    }

    public void setGetMapCallbacks(List<GetMapCallback> callbacks) {
        this.callbacks = callbacks;
    }

    public double getScaleDenominator() {
        return this.getScaleDenominator(false);
    }

    public double getScaleDenominator(boolean considerDPI) {
        HashMap<String, Object> hints = new HashMap<String, Object>();
        if (considerDPI && this.request.getFormatOptions().get("dpi") != null) {
            hints.put("dpi", this.request.getFormatOptions().get("dpi"));
        }
        if (this.request.getScaleMethod() == ScaleComputationMethod.Accurate) {
            if (this.request.getAngle() != 0.0) {
                throw new ServiceException("Accurate scale computation is not supported when using the angle parameter. This functionality could be added, please provide a pull request for it ;-)");
            }
            try {
                return RendererUtilities.calculateScale((ReferencedEnvelope)this.getViewport().getBounds(), (int)this.getMapWidth(), (int)this.getMapHeight(), hints);
            }
            catch (Exception e) {
                throw new ServiceException("Failed to compute accurate scale denominator", (Throwable)e);
            }
        }
        AffineTransform at = this.getRenderingTransform();
        if (Math.abs(XAffineTransform.getRotation((AffineTransform)at)) != 0.0) {
            return RendererUtilities.calculateOGCScaleAffine((CoordinateReferenceSystem)this.getCoordinateReferenceSystem(), (AffineTransform)at, hints);
        }
        return RendererUtilities.calculateOGCScale((ReferencedEnvelope)this.getViewport().getBounds(), (int)this.getMapWidth(), hints);
    }

    public String getRendererScaleMethod() {
        if (this.request.getScaleMethod() == ScaleComputationMethod.Accurate) {
            return "ACCURATE";
        }
        return "OGC";
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public void dispose() {
        this.request = null;
        this.callbacks = null;
        this.metadata = null;
        super.dispose();
    }
}

