/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.geoserver.catalog.AuthorityURLInfo;
import org.geoserver.catalog.LayerIdentifierInfo;
import org.geoserver.config.impl.ServiceInfoImpl;
import org.geoserver.util.InternationalStringUtils;
import org.geoserver.wms.CacheConfiguration;
import org.geoserver.wms.WMSInfo;
import org.geoserver.wms.WatermarkInfo;
import org.geoserver.wms.WatermarkInfoImpl;
import org.geotools.util.GrowableInternationalString;
import org.opengis.util.InternationalString;

public class WMSInfoImpl
extends ServiceInfoImpl
implements WMSInfo {
    public static final int DEFAULT_REMOTE_STYLE_MAX_REQUEST_TIME = 60000;
    public static final int DEFAULT_REMOTE_STYLE_TIMEOUT = 30000;
    List<String> srs = new ArrayList<String>();
    List<String> allowedURLsForAuthForwarding = new ArrayList<String>();
    Boolean bboxForEachCRS;
    WatermarkInfo watermark = new WatermarkInfoImpl();
    WMSInfo.WMSInterpolation interpolation = WMSInfo.WMSInterpolation.Nearest;
    boolean getFeatureInfoMimeTypeCheckingEnabled;
    Set<String> getFeatureInfoMimeTypes = new HashSet<String>();
    boolean getMapMimeTypeCheckingEnabled;
    Set<String> getMapMimeTypes = new HashSet<String>();
    boolean dynamicStylingDisabled;
    private boolean featuresReprojectionDisabled = false;
    protected List<AuthorityURLInfo> authorityURLs = new ArrayList<AuthorityURLInfo>(2);
    protected List<LayerIdentifierInfo> identifiers = new ArrayList<LayerIdentifierInfo>(2);
    int maxBuffer;
    int maxRequestMemory;
    int maxRenderingTime;
    int maxRenderingErrors;
    private String rootLayerTitle;
    private String rootLayerAbstract;
    private GrowableInternationalString internationalRootLayerTitle;
    private GrowableInternationalString internationalRootLayerAbstract;
    private Integer maxRequestedDimensionValues;
    private CacheConfiguration cacheConfiguration = new CacheConfiguration();
    private Integer remoteStyleMaxRequestTime;
    private Integer remoteStyleTimeout;
    private Boolean defaultGroupStyleEnabled;
    private boolean autoEscapeTemplateValues;

    public WMSInfoImpl() {
        this.authorityURLs = new ArrayList<AuthorityURLInfo>(2);
        this.identifiers = new ArrayList<LayerIdentifierInfo>(2);
    }

    public String getType() {
        return "WMS";
    }

    @Override
    public int getMaxRequestMemory() {
        return this.maxRequestMemory;
    }

    @Override
    public void setMaxRequestMemory(int maxRequestMemory) {
        this.maxRequestMemory = maxRequestMemory;
    }

    @Override
    public WatermarkInfo getWatermark() {
        return this.watermark;
    }

    @Override
    public void setWatermark(WatermarkInfo watermark) {
        this.watermark = watermark;
    }

    @Override
    public void setInterpolation(WMSInfo.WMSInterpolation interpolation) {
        this.interpolation = interpolation;
    }

    @Override
    public WMSInfo.WMSInterpolation getInterpolation() {
        return this.interpolation;
    }

    @Override
    public List<String> getSRS() {
        return this.srs;
    }

    public void setSRS(List<String> srs) {
        this.srs = srs;
    }

    @Override
    public Boolean isBBOXForEachCRS() {
        if (this.bboxForEachCRS != null) {
            return this.bboxForEachCRS;
        }
        Boolean bool = (Boolean)this.getMetadata().get("bboxForEachCRS", Boolean.class);
        return bool != null && bool != false;
    }

    @Override
    public void setBBOXForEachCRS(Boolean bboxForEachCRS) {
        this.bboxForEachCRS = bboxForEachCRS;
    }

    @Override
    public int getMaxBuffer() {
        return this.maxBuffer;
    }

    @Override
    public void setMaxBuffer(int maxBuffer) {
        this.maxBuffer = maxBuffer;
    }

    @Override
    public int getMaxRenderingTime() {
        return this.maxRenderingTime;
    }

    @Override
    public void setMaxRenderingTime(int maxRenderingTime) {
        this.maxRenderingTime = maxRenderingTime;
    }

    @Override
    public int getMaxRenderingErrors() {
        return this.maxRenderingErrors;
    }

    @Override
    public void setMaxRenderingErrors(int maxRenderingErrors) {
        this.maxRenderingErrors = maxRenderingErrors;
    }

    @Override
    public List<AuthorityURLInfo> getAuthorityURLs() {
        return this.authorityURLs;
    }

    public void setAuthorityURLs(List<AuthorityURLInfo> urls) {
        this.authorityURLs = urls;
    }

    @Override
    public List<LayerIdentifierInfo> getIdentifiers() {
        return this.identifiers;
    }

    public void setIdentifiers(List<LayerIdentifierInfo> identifiers) {
        this.identifiers = identifiers;
    }

    @Override
    public Set<String> getGetFeatureInfoMimeTypes() {
        return this.getFeatureInfoMimeTypes;
    }

    public void setGetFeatureInfoMimeTypes(Set<String> getFeatureInfoMimeTypes) {
        this.getFeatureInfoMimeTypes = getFeatureInfoMimeTypes;
    }

    @Override
    public Set<String> getGetMapMimeTypes() {
        return this.getMapMimeTypes;
    }

    public void setGetMapMimeTypes(Set<String> getMapMimeTypes) {
        this.getMapMimeTypes = getMapMimeTypes;
    }

    @Override
    public boolean isGetFeatureInfoMimeTypeCheckingEnabled() {
        return this.getFeatureInfoMimeTypeCheckingEnabled;
    }

    @Override
    public void setGetFeatureInfoMimeTypeCheckingEnabled(boolean getFeatureInfoMimeTypeCheckingEnabled) {
        this.getFeatureInfoMimeTypeCheckingEnabled = getFeatureInfoMimeTypeCheckingEnabled;
    }

    @Override
    public boolean isGetMapMimeTypeCheckingEnabled() {
        return this.getMapMimeTypeCheckingEnabled;
    }

    @Override
    public void setGetMapMimeTypeCheckingEnabled(boolean getMapMimeTypeCheckingEnabled) {
        this.getMapMimeTypeCheckingEnabled = getMapMimeTypeCheckingEnabled;
    }

    @Override
    public String getRootLayerTitle() {
        return InternationalStringUtils.getOrDefault((String)this.rootLayerTitle, (InternationalString)this.internationalRootLayerTitle);
    }

    @Override
    public void setRootLayerTitle(String rootLayerTitle) {
        this.rootLayerTitle = rootLayerTitle;
    }

    @Override
    public String getRootLayerAbstract() {
        return InternationalStringUtils.getOrDefault((String)this.rootLayerAbstract, (InternationalString)this.internationalRootLayerAbstract);
    }

    @Override
    public void setRootLayerAbstract(String rootLayerAbstract) {
        this.rootLayerAbstract = rootLayerAbstract;
    }

    @Override
    public void setDynamicStylingDisabled(Boolean dynamicStylingDisabled) {
        this.dynamicStylingDisabled = dynamicStylingDisabled;
    }

    @Override
    public Boolean isDynamicStylingDisabled() {
        return this.dynamicStylingDisabled;
    }

    @Override
    public boolean isFeaturesReprojectionDisabled() {
        return this.featuresReprojectionDisabled;
    }

    @Override
    public void setFeaturesReprojectionDisabled(boolean featuresReprojectionDisabled) {
        this.featuresReprojectionDisabled = featuresReprojectionDisabled;
    }

    @Override
    public int getMaxRequestedDimensionValues() {
        return this.maxRequestedDimensionValues == null ? 100 : this.maxRequestedDimensionValues;
    }

    @Override
    public void setMaxRequestedDimensionValues(int maxRequestedDimensionValues) {
        this.maxRequestedDimensionValues = maxRequestedDimensionValues;
    }

    @Override
    public CacheConfiguration getCacheConfiguration() {
        if (this.cacheConfiguration == null) {
            this.cacheConfiguration = new CacheConfiguration();
        }
        return this.cacheConfiguration;
    }

    @Override
    public void setCacheConfiguration(CacheConfiguration cacheCfg) {
        this.cacheConfiguration = cacheCfg;
    }

    @Override
    public int getRemoteStyleMaxRequestTime() {
        return this.remoteStyleMaxRequestTime != null ? this.remoteStyleMaxRequestTime : 60000;
    }

    @Override
    public void setRemoteStyleMaxRequestTime(int remoteStyleMaxRequestTime) {
        this.remoteStyleMaxRequestTime = remoteStyleMaxRequestTime;
    }

    @Override
    public int getRemoteStyleTimeout() {
        return this.remoteStyleTimeout != null ? this.remoteStyleTimeout : 30000;
    }

    @Override
    public void setRemoteStyleTimeout(int remoteStyleTimeout) {
        this.remoteStyleTimeout = remoteStyleTimeout;
    }

    @Override
    public boolean isDefaultGroupStyleEnabled() {
        if (this.defaultGroupStyleEnabled == null) {
            return true;
        }
        return this.defaultGroupStyleEnabled;
    }

    @Override
    public void setDefaultGroupStyleEnabled(boolean defaultGroupStyleEnabled) {
        this.defaultGroupStyleEnabled = defaultGroupStyleEnabled;
    }

    @Override
    public GrowableInternationalString getInternationalRootLayerTitle() {
        return this.internationalRootLayerTitle;
    }

    @Override
    public void setInternationalRootLayerTitle(InternationalString rootLayerTitle) {
        this.internationalRootLayerTitle = InternationalStringUtils.growable((InternationalString)rootLayerTitle);
    }

    @Override
    public GrowableInternationalString getInternationalRootLayerAbstract() {
        return this.internationalRootLayerAbstract;
    }

    @Override
    public void setInternationalRootLayerAbstract(InternationalString rootLayerAbstract) {
        this.internationalRootLayerAbstract = InternationalStringUtils.growable((InternationalString)rootLayerAbstract);
    }

    @Override
    public List<String> getAllowedURLsForAuthForwarding() {
        if (this.allowedURLsForAuthForwarding == null) {
            this.allowedURLsForAuthForwarding = new ArrayList<String>();
        }
        return this.allowedURLsForAuthForwarding;
    }

    public void setAllowedURLsForAuthForwarding(List<String> allowedURLsForAuthForwarding) {
        this.allowedURLsForAuthForwarding = allowedURLsForAuthForwarding;
    }

    @Override
    public boolean isAutoEscapeTemplateValues() {
        return this.autoEscapeTemplateValues;
    }

    @Override
    public void setAutoEscapeTemplateValues(boolean autoEscapeTemplateValues) {
        this.autoEscapeTemplateValues = autoEscapeTemplateValues;
    }
}

