/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms;

import java.awt.RenderingHints;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.MetadataMap;
import org.geoserver.catalog.PublishedType;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.ResourcePool;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.data.InternationalContentHelper;
import org.geoserver.util.GeoServerDefaultLocale;
import org.geotools.data.FeatureSource;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.wfs.WFSDataStoreFactory;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.styling.FeatureTypeConstraint;
import org.geotools.styling.Style;
import org.geotools.util.factory.GeoTools;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.grid.GridCoverageReader;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public final class MapLayerInfo {
    private static final Logger LOGGER = Logging.getLogger(MapLayerInfo.class);
    public static int TYPE_VECTOR = PublishedType.VECTOR.getCode();
    public static int TYPE_RASTER = PublishedType.RASTER.getCode();
    public static int TYPE_REMOTE_VECTOR = PublishedType.REMOTE.getCode();
    public static int TYPE_WMS = PublishedType.WMS.getCode();
    public static int TYPE_WMTS = PublishedType.WMTS.getCode();
    private final SimpleFeatureSource remoteFeatureSource;
    private final int type;
    private String name;
    private final String label;
    private final String description;
    private final LayerInfo layerInfo;
    private Style style;
    private FeatureTypeConstraint[] layerFeatureConstraints;
    private MetadataMap layerGroupMetadata;

    public MapLayerInfo(SimpleFeatureSource remoteSource) {
        this(remoteSource, new MetadataMap());
    }

    public MapLayerInfo(SimpleFeatureSource remoteSource, MetadataMap layerGroupMetadata) {
        this.remoteFeatureSource = remoteSource;
        this.layerInfo = null;
        this.label = this.name = ((SimpleFeatureType)this.remoteFeatureSource.getSchema()).getTypeName();
        this.description = "Remote WFS";
        this.type = TYPE_REMOTE_VECTOR;
        this.layerGroupMetadata = new MetadataMap((Map)layerGroupMetadata);
    }

    public MapLayerInfo(LayerInfo layerInfo) {
        this(layerInfo, new MetadataMap());
    }

    public MapLayerInfo(LayerInfo layerInfo, Locale locale) {
        this(layerInfo, new MetadataMap(), locale);
    }

    public MapLayerInfo(LayerInfo layerInfo, MetadataMap layerGroupMetadata) {
        this(layerInfo, layerGroupMetadata, GeoServerDefaultLocale.get());
    }

    public MapLayerInfo(LayerInfo layerInfo, MetadataMap layerGroupMetadata, Locale locale) {
        this.layerInfo = layerInfo;
        this.remoteFeatureSource = null;
        ResourceInfo resource = layerInfo.getResource();
        this.name = resource.prefixedName();
        this.label = this.getLabel(locale, resource);
        this.description = this.getDescription(locale, resource);
        this.type = layerInfo.getType().getCode();
        this.layerGroupMetadata = new MetadataMap((Map)layerGroupMetadata);
    }

    private String getLabel(Locale locale, ResourceInfo resourceInfo) {
        InternationalContentHelper internationalContentHelper;
        String localized;
        String label = resourceInfo.getTitle();
        if (resourceInfo.getInternationalTitle() != null && locale != null && (localized = (internationalContentHelper = new InternationalContentHelper(locale)).getString(resourceInfo.getInternationalTitle(), true)) != null) {
            label = localized;
        }
        return label;
    }

    private String getDescription(Locale locale, ResourceInfo resourceInfo) {
        InternationalContentHelper internationalContentHelper;
        String localized;
        String desc = resourceInfo.getAbstract();
        if (resourceInfo.getInternationalAbstract() != null && locale != null && (localized = (internationalContentHelper = new InternationalContentHelper(locale)).getAbstract(resourceInfo)) != null) {
            desc = localized;
        }
        return desc;
    }

    public Style getStyle() {
        return this.style;
    }

    public void setStyle(Style style) {
        this.style = style;
    }

    public ReferencedEnvelope getBoundingBox() throws Exception {
        if (this.layerInfo != null) {
            ResourceInfo resource = this.layerInfo.getResource();
            ReferencedEnvelope bbox = resource.boundingBox();
            return bbox;
        }
        if (this.type == TYPE_REMOTE_VECTOR) {
            return this.remoteFeatureSource.getBounds();
        }
        return null;
    }

    public ReferencedEnvelope getLatLongBoundingBox() throws IOException {
        if (this.layerInfo != null) {
            ResourceInfo resource = this.layerInfo.getResource();
            return resource.getLatLonBoundingBox();
        }
        throw new UnsupportedOperationException("getLatLongBoundingBox not implemented for remote sources");
    }

    public CoverageInfo getCoverage() {
        return (CoverageInfo)this.layerInfo.getResource();
    }

    public String getDescription() {
        return this.description;
    }

    public FeatureTypeInfo getFeature() {
        return (FeatureTypeInfo)this.layerInfo.getResource();
    }

    public ResourceInfo getResource() {
        return this.layerInfo.getResource();
    }

    public String getLabel() {
        return this.label;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getType() {
        return this.type;
    }

    public Style getDefaultStyle() {
        if (this.layerInfo != null) {
            try {
                return this.layerInfo.getDefaultStyle().getStyle();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public SimpleFeatureSource getRemoteFeatureSource() {
        return this.remoteFeatureSource;
    }

    public String getSRS() {
        if (this.layerInfo != null) {
            return this.layerInfo.getResource().getSRS();
        }
        return null;
    }

    public List<String> getOtherStyleNames() {
        if (this.layerInfo == null) {
            return Collections.emptyList();
        }
        ArrayList<String> styleNames = new ArrayList<String>();
        for (StyleInfo si : this.layerInfo.getStyles()) {
            styleNames.add(si.getName());
        }
        return styleNames;
    }

    public boolean isCachingEnabled() {
        if (this.type == TYPE_REMOTE_VECTOR) {
            return false;
        }
        if (this.isCachingEnabled(this.layerGroupMetadata)) {
            return true;
        }
        if (this.layerInfo == null) {
            return false;
        }
        ResourceInfo resource = this.layerInfo.getResource();
        return this.isCachingEnabled(resource.getMetadata());
    }

    private boolean isCachingEnabled(MetadataMap metadata) {
        Boolean value = (Boolean)metadata.get("cachingEnabled", Boolean.class);
        return value != null ? value : false;
    }

    public int getCacheMaxAge() {
        if (this.isCachingEnabled(this.layerGroupMetadata)) {
            return this.getCacheMaxAge(this.layerGroupMetadata);
        }
        if (this.layerInfo == null) {
            return 0;
        }
        ResourceInfo resource = this.layerInfo.getResource();
        return this.getCacheMaxAge(resource.getMetadata());
    }

    private int getCacheMaxAge(MetadataMap metadata) {
        Integer value = (Integer)metadata.get("cacheAgeMax", Integer.class);
        return value != null ? value : 0;
    }

    public FeatureSource<? extends FeatureType, ? extends Feature> getFeatureSource(boolean skipReproject, CoordinateReferenceSystem requestedCRS) throws IOException {
        if (this.type != TYPE_VECTOR) {
            throw new IllegalArgumentException("Layer type is not vector");
        }
        if (!this.layerInfo.enabled()) {
            throw new IOException("featureType: " + this.getName() + " does not have a properly configured datastore");
        }
        FeatureTypeInfo resource = (FeatureTypeInfo)this.layerInfo.getResource();
        if (resource.getStore() == null || resource.getStore().getDataStore(null) == null) {
            throw new IOException("featureType: " + this.getName() + " does not have a properly configured datastore");
        }
        Hints hints = new Hints((RenderingHints.Key)ResourcePool.REPROJECT, (Object)(!skipReproject ? 1 : 0));
        if (this.userMapCRSForWFSNG(resource, requestedCRS)) {
            hints.put((Object)ResourcePool.MAP_CRS, (Object)requestedCRS);
        }
        return resource.getFeatureSource(null, hints);
    }

    public GridCoverageReader getCoverageReader() throws IOException {
        if (this.type != TYPE_RASTER) {
            throw new IllegalArgumentException("Layer type is not raster");
        }
        CoverageInfo resource = (CoverageInfo)this.layerInfo.getResource();
        return resource.getGridCoverageReader(null, GeoTools.getDefaultHints());
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        if (this.layerInfo != null) {
            return this.layerInfo.getResource().getCRS();
        }
        if (this.remoteFeatureSource != null) {
            SimpleFeatureType schema = (SimpleFeatureType)this.remoteFeatureSource.getSchema();
            return schema.getCoordinateReferenceSystem();
        }
        throw new IllegalStateException();
    }

    public static String getRegionateAttribute(FeatureTypeInfo layerInfo) {
        return (String)layerInfo.getMetadata().get("kml.regionateAttribute", String.class);
    }

    public void setLayerFeatureConstraints(FeatureTypeConstraint[] layerFeatureConstraints) {
        this.layerFeatureConstraints = layerFeatureConstraints;
    }

    public FeatureTypeConstraint[] getLayerFeatureConstraints() {
        return this.layerFeatureConstraints;
    }

    public LayerInfo getLayerInfo() {
        return this.layerInfo;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + this.type;
        return result;
    }

    private boolean userMapCRSForWFSNG(FeatureTypeInfo resource, CoordinateReferenceSystem coordinateReferenceSystem) throws IOException {
        String otherSRSListStr = (String)((Object)resource.getMetadata().get((Object)"OTHER_SRS"));
        if (resource.getStore().getConnectionParameters().get(WFSDataStoreFactory.USEDEFAULTSRS.key) == null || otherSRSListStr == null || otherSRSListStr.isEmpty()) {
            return false;
        }
        if (Boolean.valueOf(((Serializable)resource.getStore().getConnectionParameters().get(WFSDataStoreFactory.USEDEFAULTSRS.key)).toString()).booleanValue()) {
            return false;
        }
        List<String> otherSRSList = Arrays.asList(otherSRSListStr.split(","));
        for (String otherSRS : otherSRSList) {
            try {
                if (CRS.isTransformationRequired((CoordinateReferenceSystem)CRS.decode((String)otherSRS), (CoordinateReferenceSystem)coordinateReferenceSystem)) continue;
                LOGGER.fine(otherSRS + " SRS found in Other SRS");
                return true;
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MapLayerInfo other = (MapLayerInfo)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return this.type == other.type;
    }
}

