/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.opengis.wfs.FeatureCollectionType;
import net.opengis.wfs.WfsFactory;
import org.geoserver.feature.RetypingFeatureCollection;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.FeatureInfoRequestParameters;
import org.geoserver.wms.GetFeatureInfoRequest;
import org.geoserver.wms.MapLayerInfo;
import org.geoserver.wms.featureinfo.FeatureCollectionDecorator;
import org.geoserver.wms.featureinfo.LayerIdentifier;
import org.geotools.data.DataUtilities;
import org.geotools.data.Query;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.NameImpl;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.Name;

public class GetFeatureInfo {
    static final Logger LOGGER = Logging.getLogger(GetFeatureInfo.class);

    public FeatureCollectionType run(GetFeatureInfoRequest request) throws ServiceException {
        List<FeatureCollection> results;
        try {
            results = this.execute(request);
        }
        catch (ServiceException se) {
            LOGGER.log(Level.FINE, "", se);
            throw se;
        }
        catch (Exception e) {
            LOGGER.log(Level.FINE, "", e);
            throw new ServiceException("Internal error occurred", (Throwable)e);
        }
        return this.buildResults(results);
    }

    private FeatureCollectionType buildResults(List<FeatureCollection> results) {
        FeatureCollectionType result = WfsFactory.eINSTANCE.createFeatureCollectionType();
        result.setTimeStamp(Calendar.getInstance());
        result.getFeature().addAll(results);
        return result;
    }

    private List<FeatureCollection> execute(GetFeatureInfoRequest request) throws Exception {
        List<MapLayerInfo> requestedLayers = request.getQueryLayers();
        FeatureInfoRequestParameters requestParams = new FeatureInfoRequestParameters(request);
        ArrayList<FeatureCollection> results = new ArrayList<FeatureCollection>(requestedLayers.size());
        int maxFeatures = request.getFeatureCount();
        List identifiers = GeoServerExtensions.extensions(LayerIdentifier.class);
        for (MapLayerInfo layer : requestedLayers) {
            try {
                LayerIdentifier identifier = this.getLayerIdentifier(layer, identifiers);
                List<FeatureCollection> identifiedCollections = identifier.identify(requestParams, maxFeatures);
                if (identifiedCollections != null) {
                    for (FeatureCollection identifierCollection : identifiedCollections) {
                        FeatureCollection fc = this.selectProperties(requestParams, identifierCollection);
                        maxFeatures = this.addToResults(fc, results, layer, request, maxFeatures);
                    }
                    if (maxFeatures <= 0) {
                        break;
                    }
                }
            }
            catch (Exception e) {
                throw new ServiceException("Failed to run GetFeatureInfo on layer " + layer.getName(), (Throwable)e);
            }
            requestParams.nextLayer();
        }
        return results;
    }

    private LayerIdentifier getLayerIdentifier(MapLayerInfo layer, List<LayerIdentifier> identifiers) {
        for (LayerIdentifier identifier : identifiers) {
            if (!identifier.canHandle(layer)) continue;
            return identifier;
        }
        throw new ServiceException("Could not find any identifier that can handle layer " + layer.getLayerInfo().prefixedName() + " among these identifiers: " + identifiers);
    }

    private int addToResults(FeatureCollection collection, List<FeatureCollection> results, MapLayerInfo layer, GetFeatureInfoRequest request, int maxFeatures) {
        if (collection != null) {
            int size;
            if (!(collection.getSchema() instanceof SimpleFeatureType)) {
                NameImpl name = new NameImpl(layer.getFeature().getNamespace().getName(), layer.getFeature().getName());
                collection = new FeatureCollectionDecorator((Name)name, collection);
            }
            if ((size = collection.size()) != 0) {
                if (!(collection instanceof SimpleFeatureCollection)) {
                    collection.getSchema().getUserData().put("targetCrs", request.getGetMapRequest().getCrs());
                    collection.getSchema().getUserData().put("targetVersion", "wms:getfeatureinfo");
                }
                results.add(collection);
                if ((maxFeatures -= size) <= 0) {
                    return 0;
                }
            }
        }
        return maxFeatures;
    }

    protected FeatureCollection selectProperties(FeatureInfoRequestParameters params, FeatureCollection collection) throws IOException {
        SimpleFeatureCollection sfc;
        SimpleFeatureType source;
        SimpleFeatureType target;
        String[] names = params.getPropertyNames();
        if (names != Query.ALL_NAMES && collection != null && collection.getSchema() instanceof SimpleFeatureType && !(target = SimpleFeatureTypeBuilder.retype((SimpleFeatureType)(source = (SimpleFeatureType)(sfc = DataUtilities.simple((FeatureCollection)collection)).getSchema()), (String[])names)).equals(source)) {
            return new RetypingFeatureCollection(sfc, target);
        }
        return collection;
    }
}

