/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.GetFeatureInfoRequest;
import org.geoserver.wms.GetMapRequest;
import org.geoserver.wms.MapLayerInfo;
import org.geoserver.wms.WMSMapContent;
import org.geotools.data.Query;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.styling.Style;
import org.geotools.util.factory.GeoTools;
import org.geotools.util.factory.Hints;
import org.locationtech.jts.geom.Envelope;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.sort.SortBy;
import org.opengis.filter.sort.SortOrder;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class FeatureInfoRequestParameters {
    static final FilterFactory2 FF = CommonFactoryFinder.getFilterFactory2();
    int x;
    int y;
    int buffer;
    List<Map<String, String>> viewParams;
    GetMapRequest getMapReq;
    CoordinateReferenceSystem requestedCRS;
    int width;
    int height;
    ReferencedEnvelope bbox;
    double scaleDenominator;
    List<Filter> filters;
    List<SortBy[]> sorts;
    List<MapLayerInfo> layers;
    List<Style> styles;
    List<Object> elevations;
    List<Object> times;
    FilterFactory2 ff;
    private List<List<String>> propertyNames;
    int currentLayer = 0;
    int maxFeatures;
    boolean excludeNodataResults;

    public FeatureInfoRequestParameters(GetFeatureInfoRequest request) {
        this.layers = request.getQueryLayers();
        this.filters = request.getGetMapRequest().getFilter();
        this.sorts = request.getGetMapRequest().getSortByArrays();
        this.styles = this.getStyles(request, this.layers);
        this.x = request.getXPixel();
        this.y = request.getYPixel();
        this.buffer = request.getGetMapRequest().getBuffer();
        this.viewParams = request.getGetMapRequest().getViewParams();
        this.getMapReq = request.getGetMapRequest();
        this.requestedCRS = this.getMapReq.getCrs();
        this.maxFeatures = request.getFeatureCount();
        this.excludeNodataResults = request.isExcludeNodataResults();
        this.width = this.getMapReq.getWidth();
        this.height = this.getMapReq.getHeight();
        this.bbox = new ReferencedEnvelope(this.getMapReq.getBbox(), this.getMapReq.getCrs());
        this.scaleDenominator = this.getScaleDenominator(request.getGetMapRequest());
        this.elevations = request.getGetMapRequest().getElevation();
        this.times = request.getGetMapRequest().getTime();
        this.ff = CommonFactoryFinder.getFilterFactory2((Hints)GeoTools.getDefaultHints());
        this.propertyNames = request.getPropertyNames();
    }

    private double getScaleDenominator(GetMapRequest request) {
        Envelope envelope = request.getBbox();
        CoordinateReferenceSystem mapcrs = request.getCrs();
        WMSMapContent mapContent = new WMSMapContent(request);
        if (mapcrs != null) {
            mapContent.getViewport().setBounds(new ReferencedEnvelope(envelope, mapcrs));
        } else {
            mapContent.getViewport().setBounds(new ReferencedEnvelope(envelope, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84));
        }
        mapContent.setMapWidth(request.getWidth());
        mapContent.setMapHeight(request.getHeight());
        mapContent.setAngle(request.getAngle());
        return mapContent.getScaleDenominator(true);
    }

    private List<Style> getStyles(GetFeatureInfoRequest request, List<MapLayerInfo> layers) {
        List<Style> getMapStyles = request.getGetMapRequest().getStyles();
        ArrayList<Style> styles = new ArrayList<Style>();
        List<MapLayerInfo> getMapLayers = request.getGetMapRequest().getLayers();
        for (MapLayerInfo layer : layers) {
            String targetLayer = layer.getName();
            Style s = null;
            for (int j = 0; j < getMapLayers.size(); ++j) {
                if (!getMapLayers.get(j).getName().equals(targetLayer)) continue;
                if (getMapStyles != null && getMapStyles.size() > j) {
                    s = getMapStyles.get(j);
                    break;
                }
                s = getMapLayers.get(j).getDefaultStyle();
                break;
            }
            if (s != null) {
                styles.add(s);
                continue;
            }
            throw new ServiceException("Failed to locate style for layer " + targetLayer);
        }
        return styles;
    }

    void nextLayer() {
        ++this.currentLayer;
    }

    public MapLayerInfo getLayer() {
        return this.layers.get(this.currentLayer);
    }

    public Style getStyle() {
        return this.styles.get(this.currentLayer);
    }

    public Filter getFilter() {
        if (this.filters == null || this.filters.size() <= this.currentLayer) {
            return null;
        }
        return this.filters.get(this.currentLayer);
    }

    public SortBy[] getSort() {
        if (this.sorts == null || this.sorts.size() <= this.currentLayer) {
            return null;
        }
        SortBy[] layerSort = this.sorts.get(this.currentLayer);
        MapLayerInfo layer = this.layers.get(this.currentLayer);
        if (layer.getType() == MapLayerInfo.TYPE_VECTOR || layer.getType() == MapLayerInfo.TYPE_REMOTE_VECTOR) {
            SortBy[] result = new SortBy[layerSort.length];
            for (int i = 0; i < layerSort.length; ++i) {
                SortBy reverse;
                SortBy sb = layerSort[i];
                SortOrder order = sb.getSortOrder();
                result[i] = reverse = FF.sort(sb.getPropertyName().getPropertyName(), order == SortOrder.ASCENDING || order == null ? SortOrder.DESCENDING : SortOrder.ASCENDING);
            }
            return result;
        }
        return layerSort;
    }

    public String[] getPropertyNames() {
        if (this.propertyNames == null || this.propertyNames.isEmpty() || this.propertyNames.get(this.currentLayer) == null) {
            return Query.ALL_NAMES;
        }
        List<String> layerPropNames = this.propertyNames.get(this.currentLayer);
        return layerPropNames.toArray(new String[layerPropNames.size()]);
    }

    public Map<String, String> getViewParams() {
        if (this.viewParams == null || this.viewParams.size() < this.currentLayer) {
            return null;
        }
        return this.viewParams.get(this.currentLayer);
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getBuffer() {
        return this.buffer;
    }

    public CoordinateReferenceSystem getRequestedCRS() {
        return this.requestedCRS;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public ReferencedEnvelope getRequestedBounds() {
        return this.bbox;
    }

    public double getScaleDenominator() {
        return this.scaleDenominator;
    }

    public List<Object> getElevations() {
        return this.elevations;
    }

    public List<Object> getTimes() {
        return this.times;
    }

    public FilterFactory2 getFilterFactory() {
        return this.ff;
    }

    public GetMapRequest getGetMapRequest() {
        return this.getMapReq;
    }

    public boolean isExcludeNodataResults() {
        return this.excludeNodataResults;
    }
}

