/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import net.opengis.wfs.FeatureCollectionType;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.ServiceException;
import org.geoserver.sld.GetStyles;
import org.geoserver.sld.GetStylesRequest;
import org.geoserver.wms.DescribeLayer;
import org.geoserver.wms.DescribeLayerRequest;
import org.geoserver.wms.GetCapabilities;
import org.geoserver.wms.GetCapabilitiesRequest;
import org.geoserver.wms.GetFeatureInfo;
import org.geoserver.wms.GetFeatureInfoRequest;
import org.geoserver.wms.GetLegendGraphic;
import org.geoserver.wms.GetLegendGraphicRequest;
import org.geoserver.wms.GetMap;
import org.geoserver.wms.GetMapDefaults;
import org.geoserver.wms.GetMapRequest;
import org.geoserver.wms.ThreadLocalTransferExecutor;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSInfo;
import org.geoserver.wms.WebMap;
import org.geoserver.wms.WebMapService;
import org.geoserver.wms.describelayer.DescribeLayerModel;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.styling.Style;
import org.geotools.styling.StyledLayerDescriptor;
import org.geotools.util.SuppressFBWarnings;
import org.geotools.xml.transform.TransformerBase;
import org.locationtech.jts.geom.Envelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class DefaultWebMapService
implements WebMapService,
ApplicationContextAware,
DisposableBean {
    public static String FORMAT = "image/png";
    public static List<Style> STYLES = Collections.emptyList();
    public static int MAX_SIDE = 768;
    public static int MIN_OL_HEIGHT = 330;
    public static int MIN_OL_WIDTH = 330;
    public static int MAX_OL_HEIGHT = 768;
    public static int MAX_OL_WIDTH = 1024;
    public static String SRS = "EPSG:4326";
    public static Boolean TRANSPARENT = Boolean.TRUE;
    public static volatile ExecutorService RENDERING_POOL;
    public static ReferencedEnvelope BBOX;
    private final WMS wms;
    private static Boolean OPTIMIZE_LINE_WIDTH;
    private static boolean BYPASS_DIRECT;
    private static Integer MAX_FILTER_RULES;
    private static Boolean USE_GLOBAL_RENDERING_POOL;
    private GetCapabilities getCapabilities;
    private DescribeLayer describeLayer;
    private GetMap getMap;
    private GetFeatureInfo getFeatureInfo;
    private GetStyles getStyles;
    private GetLegendGraphic getLegendGraphic;

    public DefaultWebMapService(WMS wms) {
        this.wms = wms;
    }

    @Override
    public WMSInfo getServiceInfo() {
        return this.wms.getServiceInfo();
    }

    public void setGetCapabilities(GetCapabilities getCapabilities) {
        this.getCapabilities = getCapabilities;
    }

    public void setDescribeLayer(DescribeLayer describeLayer) {
        this.describeLayer = describeLayer;
    }

    public void setGetMap(GetMap getMap) {
        this.getMap = getMap;
    }

    public void setGetFeatureInfo(GetFeatureInfo getFeatureInfo) {
        this.getFeatureInfo = getFeatureInfo;
    }

    public void setGetStyles(GetStyles getStyles) {
        this.getStyles = getStyles;
    }

    public void setGetLegendGraphic(GetLegendGraphic getLegendGraphic) {
        this.getLegendGraphic = getLegendGraphic;
    }

    @SuppressFBWarnings(value={"LI_LAZY_INIT_STATIC"})
    public void setApplicationContext(ApplicationContext context) throws BeansException {
        if (OPTIMIZE_LINE_WIDTH == null) {
            String enabled = GeoServerExtensions.getProperty((String)"OPTIMIZE_LINE_WIDTH", (ApplicationContext)context);
            OPTIMIZE_LINE_WIDTH = enabled == null ? Boolean.valueOf(false) : Boolean.valueOf(enabled);
        }
        if (MAX_FILTER_RULES == null) {
            String rules = GeoServerExtensions.getProperty((String)"MAX_FILTER_RULES", (ApplicationContext)context);
            MAX_FILTER_RULES = rules == null ? Integer.valueOf(20) : Integer.valueOf(rules);
        }
        if (USE_GLOBAL_RENDERING_POOL == null) {
            String usePool = GeoServerExtensions.getProperty((String)"USE_GLOBAL_RENDERING_POOL", (ApplicationContext)context);
            USE_GLOBAL_RENDERING_POOL = usePool == null ? Boolean.valueOf(true) : Boolean.valueOf(usePool);
        }
    }

    public static boolean isLineWidthOptimizationEnabled() {
        return OPTIMIZE_LINE_WIDTH;
    }

    public static int getMaxFilterRules() {
        return MAX_FILTER_RULES;
    }

    public static boolean isDirectRasterPathEnabled() {
        return !BYPASS_DIRECT;
    }

    public TransformerBase getCapabilities(GetCapabilitiesRequest request) {
        if (null == this.getCapabilities) {
            throw new UnsupportedOperationException("Operation not properly configured, make sure the operation bean has been set");
        }
        return this.getCapabilities.run(request);
    }

    public TransformerBase capabilities(GetCapabilitiesRequest request) {
        return this.getCapabilities(request);
    }

    @Override
    public DescribeLayerModel describeLayer(DescribeLayerRequest request) {
        if (null == this.describeLayer) {
            throw new UnsupportedOperationException("Operation not properly configured, make sure the operation bean has been set");
        }
        return DescribeLayer.run(request);
    }

    @Override
    public WebMap getMap(GetMapRequest request) {
        if (null == this.getMap) {
            throw new UnsupportedOperationException("Operation not properly configured, make sure the operation bean has been set");
        }
        return this.getMap.run(request);
    }

    @Override
    public WebMap map(GetMapRequest request) {
        return this.getMap(request);
    }

    @Override
    public FeatureCollectionType getFeatureInfo(GetFeatureInfoRequest request) {
        if (null == this.getFeatureInfo) {
            throw new UnsupportedOperationException("Operation not properly configured, make sure the operation bean has been set");
        }
        return this.getFeatureInfo.run(request);
    }

    @Override
    public Object getLegendGraphic(GetLegendGraphicRequest request) {
        if (null == this.getLegendGraphic) {
            throw new UnsupportedOperationException("Operation not properly configured, make sure the operation bean has been set");
        }
        return this.getLegendGraphic.run(request);
    }

    @Override
    public WebMap kml(GetMapRequest getMap) {
        throw new ServiceException("kml service is not available, please include a KML module in WEB-INF/lib");
    }

    @Override
    public WebMap reflect(GetMapRequest request) {
        return this.getMapReflect(request);
    }

    @Override
    public StyledLayerDescriptor getStyles(GetStylesRequest request) {
        return this.getStyles.run(request);
    }

    @Override
    public WebMap getMapReflect(GetMapRequest request) {
        GetMapRequest getMap = DefaultWebMapService.autoSetMissingProperties(request);
        return this.getMap(getMap);
    }

    public static GetMapRequest autoSetMissingProperties(GetMapRequest getMap) {
        return new GetMapDefaults().autoSetMissingProperties(getMap);
    }

    public static void autoSetBoundsAndSize(GetMapRequest getMap) {
        new GetMapDefaults().autoSetBoundsAndSize(getMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ExecutorService getRenderingPool() {
        if (!USE_GLOBAL_RENDERING_POOL.booleanValue() || RENDERING_POOL != null) return RENDERING_POOL;
        Class<DefaultWebMapService> clazz = DefaultWebMapService.class;
        synchronized (DefaultWebMapService.class) {
            if (RENDERING_POOL != null) return RENDERING_POOL;
            RENDERING_POOL = new ThreadLocalTransferExecutor();
            // ** MonitorExit[var0] (shouldn't be in output)
            return RENDERING_POOL;
        }
    }

    public void destroy() throws Exception {
        if (RENDERING_POOL != null) {
            RENDERING_POOL.shutdown();
            RENDERING_POOL.awaitTermination(10L, TimeUnit.SECONDS);
            RENDERING_POOL = null;
        }
    }

    static {
        BBOX = new ReferencedEnvelope(new Envelope(-180.0, 180.0, -90.0, 90.0), (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        OPTIMIZE_LINE_WIDTH = null;
        BYPASS_DIRECT = Boolean.getBoolean("org.geoserver.render.raster.direct.disable");
        MAX_FILTER_RULES = null;
        USE_GLOBAL_RENDERING_POOL = null;
    }
}

