/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.layer;

import com.google.common.base.Preconditions;
import it.geosolutions.jaiext.BufferedImageAdapter;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.OutputStream;
import javax.media.jai.PlanarImage;
import org.geoserver.gwc.GWC;
import org.geoserver.ows.Response;
import org.geoserver.wms.WMSMapContent;
import org.geoserver.wms.WebMap;
import org.geoserver.wms.map.RawMap;
import org.geoserver.wms.map.RenderedImageMap;
import org.geoserver.wms.map.RenderedImageMapResponse;
import org.geoserver.wms.map.RenderedImageTimeDecorator;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.image.ImageWorker;
import org.geotools.metadata.i18n.Errors;
import org.geowebcache.grid.BoundingBox;
import org.geowebcache.grid.GridSubset;
import org.geowebcache.io.Resource;
import org.geowebcache.layer.MetaTile;
import org.geowebcache.mime.FormatModifier;
import org.geowebcache.mime.MimeType;

public class GeoServerMetaTile
extends MetaTile {
    private WebMap metaTileMap;

    public GeoServerMetaTile(GridSubset gridSubset, MimeType responseFormat, FormatModifier formatModifier, long[] tileGridPosition, int metaX, int metaY, Integer gutter) {
        super(gridSubset, responseFormat, formatModifier, tileGridPosition, metaX, metaY, gutter);
    }

    public void setWebMap(WebMap webMap) {
        this.metaTileMap = webMap;
        if (webMap instanceof RenderedImageMap) {
            this.setImage(((RenderedImageMap)webMap).getImage());
        }
    }

    public boolean writeTileToStream(int tileIdx, Resource target) throws IOException {
        Preconditions.checkNotNull((Object)this.metaTileMap, (Object)"webMap is not set");
        if (this.metaTileMap instanceof RawMap) {
            try (OutputStream outStream = target.getOutputStream();){
                ((RawMap)this.metaTileMap).writeTo(outStream);
            }
            return true;
        }
        if (!(this.metaTileMap instanceof RenderedImageMap)) {
            throw new IllegalArgumentException("Only RenderedImageMaps are supported so far: " + this.metaTileMap.getClass().getName());
        }
        RenderedImageMap metaTileMap = (RenderedImageMap)this.metaTileMap;
        GWC mediator = GWC.get();
        Response responseEncoder = mediator.getResponseEncoder(this.responseFormat, metaTileMap);
        RenderedImageMapResponse mapEncoder = (RenderedImageMapResponse)responseEncoder;
        RenderedImage tile = metaTileMap.getImage();
        WMSMapContent tileContext = metaTileMap.getMapContext();
        if (this.tiles.length > 1 || this.tiles.length == 1 && this.metaHasGutter()) {
            Rectangle tileDim = this.tiles[tileIdx];
            tile = this.createTile(tileDim.x, tileDim.y, tileDim.width, tileDim.height);
            this.disposeLater(tile);
            WMSMapContent metaTileContext = metaTileMap.getMapContext();
            tileContext = new WMSMapContent();
            tileContext.setRequest(metaTileContext.getRequest());
            tileContext.setBgColor(metaTileContext.getBgColor());
            tileContext.setMapWidth(tileDim.width);
            tileContext.setMapHeight(tileDim.height);
            tileContext.setPalette(metaTileContext.getPalette());
            tileContext.setTransparent(tileContext.isTransparent());
            long[][] tileIndexes = this.getTilesGridPositions();
            BoundingBox tileBounds = this.gridSubset.boundsFromIndex(tileIndexes[tileIdx]);
            ReferencedEnvelope tilebbox = new ReferencedEnvelope(metaTileContext.getCoordinateReferenceSystem());
            tilebbox.init(tileBounds.getMinX(), tileBounds.getMaxX(), tileBounds.getMinY(), tileBounds.getMaxY());
            tileContext.getViewport().setBounds(tilebbox);
        }
        try (OutputStream outStream = target.getOutputStream();){
            mapEncoder.formatImageOutputStream(tile, outStream, tileContext);
            boolean bl = true;
            return bl;
        }
    }

    private boolean metaHasGutter() {
        if (this.gutter == null) {
            return false;
        }
        for (int element : this.gutter) {
            if (element <= 0) continue;
            return true;
        }
        return false;
    }

    public RenderedImage createTile(int x, int y, int tileWidth, int tileHeight) {
        Object tile;
        int type = this.metaTileImage instanceof PlanarImage ? 1 : (this.metaTileImage instanceof BufferedImage ? 2 : 0);
        switch (type) {
            case 0: {
                ImageWorker w = new ImageWorker(this.metaTileImage);
                w.crop(Float.valueOf(x).floatValue(), Float.valueOf(y).floatValue(), Float.valueOf(tileWidth).floatValue(), Float.valueOf(tileHeight).floatValue());
                tile = w.getBufferedImage();
                this.disposeLater(w.getRenderedImage());
                break;
            }
            case 1: {
                PlanarImage pImage = (PlanarImage)this.metaTileImage;
                WritableRaster wTile = WritableRaster.createWritableRaster(pImage.getSampleModel().createCompatibleSampleModel(tileWidth, tileHeight), new Point(x, y));
                Rectangle sourceArea = new Rectangle(x, y, tileWidth, tileHeight);
                sourceArea = sourceArea.intersection(pImage.getBounds());
                pImage.copyData(wTile);
                if (wTile.getMinX() != 0 || wTile.getMinY() != 0) {
                    tile = new BufferedImage(pImage.getColorModel(), (WritableRaster)wTile.createTranslatedChild(0, 0), pImage.getColorModel().isAlphaPremultiplied(), null);
                    break;
                }
                tile = new BufferedImage(pImage.getColorModel(), wTile, pImage.getColorModel().isAlphaPremultiplied(), null);
                break;
            }
            case 2: {
                BufferedImage image = (BufferedImage)this.metaTileImage;
                BufferedImage subimage = image.getSubimage(x, y, tileWidth, tileHeight);
                tile = new BufferedImageAdapter(subimage);
                break;
            }
            default: {
                throw new IllegalStateException(Errors.format((int)58, (Object)"metaTile class", (Object)this.metaTileImage.getClass().toString()));
            }
        }
        return tile;
    }

    public void dispose() {
        if (this.metaTileMap != null) {
            this.metaTileMap.dispose();
            this.metaTileMap = null;
        }
        if (this.metaTileImage instanceof RenderedImageTimeDecorator) {
            this.metaTileImage = ((RenderedImageTimeDecorator)this.metaTileImage).getDelegate();
        }
        super.dispose();
    }
}

