/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.dispatch;

import java.util.Objects;
import org.geoserver.gwc.GWC;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.ows.ServiceException;
import org.geotools.referencing.CRS;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.filter.security.SecurityFilter;
import org.geowebcache.grid.BoundingBox;
import org.geowebcache.grid.SRS;
import org.geowebcache.layer.TileLayer;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.FactoryException;

public class GeoServerSecurityFilter
implements SecurityFilter {
    public void checkSecurity(TileLayer layer, BoundingBox extent, SRS srs) throws SecurityException, GeoWebCacheException {
        if (GWC.get().getConfig().isSecurityEnabled()) {
            try {
                ReferencedEnvelope env = Objects.nonNull(extent) ? new ReferencedEnvelope(extent.getMinX(), extent.getMaxX(), extent.getMinY(), extent.getMaxY(), CRS.decode((String)srs.toString())) : null;
                GWC.get().verifyAccessLayer(layer.getName(), env);
            }
            catch (ServiceException | MismatchedDimensionException | FactoryException e) {
                throw new GeoWebCacheException(e);
            }
        }
    }
}

