/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.controller;

import java.lang.reflect.Method;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.ows.LocalWorkspace;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

public class GwcUrlHandlerMapping
extends RequestMappingHandlerMapping
implements HandlerInterceptor {
    protected String GWC_URL_PATTERN = "";
    private final Catalog catalog;

    public GwcUrlHandlerMapping(Catalog catalog, String gwcUrlPattern) {
        this.catalog = catalog;
        this.GWC_URL_PATTERN = gwcUrlPattern;
    }

    protected void registerHandlerMethod(Object handler, Method method, RequestMappingInfo mapping) {
        for (String pattern : mapping.getPatternsCondition().getPatterns()) {
            if (!pattern.contains(this.GWC_URL_PATTERN)) continue;
            super.registerHandlerMethod(handler, method, mapping);
            break;
        }
    }

    protected HandlerMethod lookupHandlerMethod(String lookupPath, HttpServletRequest request) throws Exception {
        int gwcRestBaseIndex = lookupPath.indexOf(this.GWC_URL_PATTERN);
        if (gwcRestBaseIndex == -1 || gwcRestBaseIndex == 0) {
            return null;
        }
        int startIndex = lookupPath.charAt(0) == '/' ? 1 : 0;
        String workspaceName = lookupPath.substring(startIndex, gwcRestBaseIndex);
        WorkspaceInfo workspace = this.catalog.getWorkspaceByName(workspaceName);
        if (workspace == null) {
            return null;
        }
        HandlerMethod handler = super.lookupHandlerMethod(lookupPath.substring(gwcRestBaseIndex), (HttpServletRequest)new Wrapper(request, this.catalog, workspaceName));
        if (handler == null) {
            return null;
        }
        LocalWorkspace.set((WorkspaceInfo)workspace);
        return handler;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) {
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        LocalWorkspace.remove();
    }

    private static final class Wrapper
    extends HttpServletRequestWrapper {
        private final String requestUri;

        Wrapper(HttpServletRequest request, Catalog catalog, String workspaceName) {
            super(request);
            request.setAttribute(HandlerMapping.LOOKUP_PATH, (Object)((String)request.getAttribute(HandlerMapping.LOOKUP_PATH)).replace(workspaceName + "/", ""));
            this.requestUri = request.getRequestURI().replace(workspaceName + "/", "");
        }

        public String getRequestURI() {
            return this.requestUri;
        }
    }
}

