/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.config;

import com.google.common.base.Preconditions;
import com.thoughtworks.xstream.XStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.config.util.XStreamPersister;
import org.geoserver.config.util.XStreamPersisterFactory;
import org.geoserver.gwc.config.GWCConfig;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.platform.resource.Resource;
import org.geoserver.util.DimensionWarning;
import org.geotools.util.logging.Logging;
import org.geowebcache.storage.blobstore.memory.CacheConfiguration;

public class GWCConfigPersister {
    private static final Logger LOGGER = Logging.getLogger(GWCConfigPersister.class);
    static final String GWC_CONFIG_FILE = "gwc-gs.xml";
    private final XStreamPersisterFactory persisterFactory;
    private final GeoServerResourceLoader resourceLoader;
    private GWCConfig config;

    public GWCConfigPersister(XStreamPersisterFactory xspf, GeoServerResourceLoader resourceLoader) {
        this.persisterFactory = xspf;
        this.resourceLoader = resourceLoader;
    }

    Resource findConfigFile() throws IOException {
        Resource configFile = this.resourceLoader.get(GWC_CONFIG_FILE);
        return configFile;
    }

    public GWCConfig getConfig() {
        if (this.config == null) {
            try {
                this.loadConfig();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return this.config;
    }

    private synchronized void loadConfig() throws IOException {
        Resource configFile = this.findConfigFile();
        Preconditions.checkNotNull((Object)configFile, (String)"gwc config file does not exist: ", (Object)GWC_CONFIG_FILE);
        XStreamPersister xmlPersister = this.persisterFactory.createXMLPersister();
        this.configureXstream(xmlPersister.getXStream());
        try {
            try (InputStream in = configFile.in();){
                this.config = (GWCConfig)xmlPersister.load(in, GWCConfig.class);
            }
            LOGGER.fine("GWC GeoServer specific configuration loaded from gwc-gs.xml");
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Error loading GWC GeoServer specific configuration from " + configFile.path() + ". Applying defaults.", e);
            this.config = new GWCConfig();
        }
    }

    public void save(GWCConfig config) throws IOException {
        LOGGER.finer("Saving integrated GWC configuration");
        Resource tmp = this.getConfigRoot().get("gwc-gs.xml.tmp");
        XStreamPersister xmlPersister = this.persisterFactory.createXMLPersister();
        this.configureXstream(xmlPersister.getXStream());
        try (OutputStream out = tmp.out();){
            xmlPersister.save((Object)config, out);
        }
        Resource configFile = this.getConfigRoot().get(GWC_CONFIG_FILE);
        tmp.renameTo(configFile);
        this.config = config;
        LOGGER.finer("Integrated GWC configuration saved to " + configFile.path());
    }

    private void configureXstream(XStream xs) {
        xs.alias("GeoServerGWCConfig", GWCConfig.class);
        xs.alias("defaultCachingGridSetIds", HashSet.class);
        xs.alias("defaultCoverageCacheFormats", HashSet.class);
        xs.alias("defaultVectorCacheFormats", HashSet.class);
        xs.alias("defaultOtherCacheFormats", HashSet.class);
        xs.alias("InnerCacheConfiguration", CacheConfiguration.class);
        xs.alias("warning", DimensionWarning.WarningType.class);
        xs.allowTypes(new Class[]{GWCConfig.class, CacheConfiguration.class, DimensionWarning.WarningType.class});
        xs.addDefaultImplementation(LinkedHashSet.class, Set.class);
    }

    private Resource getConfigRoot() {
        return this.resourceLoader.get("");
    }
}

