/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.gwc.ConfigurableQuotaStore;
import org.geoserver.gwc.DummyQuotaStore;
import org.geoserver.gwc.GWC;
import org.geoserver.gwc.JDBCConfigurationStorage;
import org.geoserver.platform.GeoServerExtensions;
import org.geotools.util.logging.Logging;
import org.geowebcache.config.ConfigurationException;
import org.geowebcache.diskquota.ConfigLoader;
import org.geowebcache.diskquota.DiskQuotaConfig;
import org.geowebcache.diskquota.QuotaStore;
import org.geowebcache.diskquota.QuotaStoreProvider;
import org.geowebcache.diskquota.jdbc.JDBCConfiguration;
import org.geowebcache.diskquota.jdbc.JDBCQuotaStoreFactory;
import org.geowebcache.diskquota.storage.TilePageCalculator;
import org.geowebcache.layer.TileLayer;
import org.springframework.context.ApplicationContext;

public class ConfigurableQuotaStoreProvider
extends QuotaStoreProvider {
    static final Logger LOGGER = Logging.getLogger(ConfigurableQuotaStoreProvider.class);
    Exception exception;
    TilePageCalculator calculator;
    boolean diskQuotaEnabled;
    private JDBCConfigurationStorage jdbcConfigManager;

    public ConfigurableQuotaStoreProvider(ConfigLoader loader, TilePageCalculator calculator, JDBCConfigurationStorage jdbcConfigManager) {
        super(loader);
        this.calculator = calculator;
        this.jdbcConfigManager = jdbcConfigManager;
        boolean disabled = Boolean.parseBoolean(GeoServerExtensions.getProperty((String)"GWC_DISKQUOTA_DISABLED"));
        if (disabled) {
            LOGGER.warning(" -- Found environment variable GWC_DISKQUOTA_DISABLED set to true. DiskQuotaMonitor is disabled.");
        }
        this.diskQuotaEnabled = !disabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadQuotaStore() throws ConfigurationException, IOException {
        if (!this.diskQuotaEnabled) {
            this.store = null;
            return;
        }
        DiskQuotaConfig config = this.loader.loadConfig();
        DummyQuotaStore store = null;
        if (!config.isEnabled().booleanValue()) {
            store = new DummyQuotaStore(this.calculator);
        } else {
            String quotaStoreName = config.getQuotaStore();
            if (quotaStoreName == null) {
                quotaStoreName = "H2";
            }
            try {
                store = this.getQuotaStoreByName(quotaStoreName);
                this.exception = null;
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Failed to get a quota store, the GeoWebCache disk quota subsystem will stop working now", e);
                this.exception = e;
                store = new DummyQuotaStore(this.calculator);
            }
        }
        if (this.store == null) {
            this.store = new ConfigurableQuotaStore(store);
        } else {
            ConfigurableQuotaStore configurable = (ConfigurableQuotaStore)this.store;
            QuotaStore oldStore = configurable.getStore();
            configurable.setStore(store);
            if (!(oldStore instanceof DummyQuotaStore)) {
                try {
                    for (TileLayer tl : GWC.get().getTileLayers()) {
                        oldStore.deleteLayer(tl.getName());
                    }
                }
                finally {
                    try {
                        oldStore.close();
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.SEVERE, "An error occurred while closing up the previous quota store", e);
                    }
                }
            }
        }
    }

    public Exception getException() {
        return this.exception;
    }

    protected QuotaStore getQuotaStoreByName(String quotaStoreName) throws ConfigurationException, IOException {
        if ("JDBC".equals(quotaStoreName)) {
            return this.loadJDBCQuotaStore(this.applicationContext, quotaStoreName);
        }
        return super.getQuotaStoreByName(quotaStoreName);
    }

    private QuotaStore loadJDBCQuotaStore(ApplicationContext applicationContext, String quotaStoreName) throws ConfigurationException, IOException {
        JDBCConfiguration config = this.jdbcConfigManager.getJDBCDiskQuotaConfig();
        JDBCQuotaStoreFactory factory = new JDBCQuotaStoreFactory();
        factory.setApplicationContext(applicationContext);
        return factory.getJDBCStore(applicationContext, config);
    }
}

