/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest.converters;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.logging.Logger;
import org.geoserver.rest.RequestInfo;
import org.geoserver.rest.converters.BaseMessageConverter;
import org.geotools.util.logging.Logging;
import org.springframework.http.MediaType;

public abstract class XStreamMessageConverter<T>
extends BaseMessageConverter<T> {
    static final Logger LOGGER = Logging.getLogger(XStreamMessageConverter.class);

    public XStreamMessageConverter(MediaType ... supportedMediaTypes) {
        super(supportedMediaTypes);
    }

    public abstract void encodeLink(String var1, HierarchicalStreamWriter var2);

    public abstract void encodeCollectionLink(String var1, HierarchicalStreamWriter var2);

    protected abstract XStream createXStreamInstance();

    protected void encodeAlternateAtomLink(String link, HierarchicalStreamWriter writer) {
        writer.startNode("atom:link");
        writer.addAttribute("xmlns:atom", "http://www.w3.org/2005/Atom");
        writer.addAttribute("rel", "alternate");
        writer.addAttribute("href", this.href(link));
        writer.addAttribute("type", this.getMediaType());
        writer.endNode();
    }

    protected String href(String link) {
        RequestInfo pg = RequestInfo.get();
        String ext = this.getExtension();
        if (ext != null && ext.length() > 0) {
            link = link + "." + ext;
        }
        if (link.startsWith("/")) {
            return pg.servletURI(link);
        }
        return pg.pageURI(link);
    }

    public String encode(String component) {
        try {
            return URLEncoder.encode(component, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.warning("Unable to URL-encode component: " + component);
            return component;
        }
    }

    public abstract String getExtension();

    public abstract String getMediaType();
}

