/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest.converters;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.geoserver.rest.converters.BaseMessageConverter;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;

public class InputStreamConverter
extends BaseMessageConverter<InputStream> {
    public InputStreamConverter() {
        super(MediaType.ALL);
    }

    protected boolean canRead(MediaType mediaType) {
        return false;
    }

    protected boolean supports(Class<?> clazz) {
        return InputStream.class.isAssignableFrom(clazz);
    }

    @Override
    protected InputStream readInternal(Class<? extends InputStream> clazz, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        throw new HttpMessageNotReadableException(((Object)((Object)this)).getClass().getName() + " does not support deserialization", inputMessage);
    }

    @Override
    protected void writeInternal(InputStream inputStream, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        try {
            IOUtils.copy((InputStream)inputStream, (OutputStream)outputMessage.getBody());
        }
        finally {
            inputStream.close();
        }
    }
}

