/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest.converters;

import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.config.GeoServer;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.rest.RequestInfo;
import org.geoserver.rest.converters.BaseMessageConverter;
import org.geoserver.rest.wrapper.RestWrapper;
import org.geotools.util.logging.Logging;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;

public class FreemarkerHTMLMessageConverter
extends BaseMessageConverter<RestWrapper<?>> {
    static final Logger LOGGER = Logging.getLogger(FreemarkerHTMLMessageConverter.class);
    protected String encoding;

    public FreemarkerHTMLMessageConverter() {
        super(MediaType.TEXT_HTML);
    }

    public FreemarkerHTMLMessageConverter(String encoding) {
        this();
        this.encoding = encoding;
    }

    protected boolean supports(Class<?> clazz) {
        return RestWrapper.class.isAssignableFrom(clazz);
    }

    protected boolean canRead(MediaType mediaType) {
        return false;
    }

    @Override
    protected RestWrapper<?> readInternal(Class<? extends RestWrapper<?>> clazz, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void writeInternal(RestWrapper<?> wrapper, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        MediaType contentType = outputMessage.getHeaders().getContentType();
        BufferedWriter templateWriter = null;
        wrapper.configureFreemarker(this);
        try {
            Object object = wrapper.getObject();
            Template template = wrapper.getTemplate();
            OutputStream outputStream = outputMessage.getBody();
            Charset charSet = contentType != null ? contentType.getCharset() : this.getGeoServerDefaultCharset();
            templateWriter = charSet != null ? new BufferedWriter(new OutputStreamWriter(outputStream, charSet.name())) : new BufferedWriter(new OutputStreamWriter(outputStream, template.getEncoding()));
            template.process(object, (Writer)templateWriter);
            ((Writer)templateWriter).flush();
        }
        catch (TemplateException te) {
            throw new IOException("Template processing error " + te.getMessage());
        }
    }

    private Charset getGeoServerDefaultCharset() {
        return Charset.forName(((GeoServer)GeoServerExtensions.bean(GeoServer.class)).getGlobal().getSettings().getCharset());
    }

    @Override
    public int getPriority() {
        return 99;
    }

    public List<URL> createCollectionLink(String link) {
        try {
            String href = this.href(link);
            URL url2 = new URL(href);
            return Collections.singletonList(url2);
        }
        catch (MalformedURLException e) {
            LOGGER.log(Level.WARNING, "", e);
            return new ArrayList<URL>();
        }
    }

    protected String href(String link) {
        RequestInfo pg = RequestInfo.get();
        if ((link = link + ".html").startsWith("/")) {
            return pg.servletURI(link);
        }
        return pg.pageURI(link);
    }
}

