/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.geoserver.ows.URLMangler;
import org.geoserver.ows.util.ResponseUtils;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

public class RequestInfo {
    public static final String KEY = "RequestInfo";
    String baseURL;
    String servletPath;
    String pagePath;
    String extension;
    private Map<String, String[]> queryMap;

    public RequestInfo() {
    }

    public RequestInfo(HttpServletRequest request) {
        this.baseURL = request.getRequestURL().toString().replace(request.getRequestURI(), request.getContextPath());
        this.servletPath = request.getServletPath();
        this.pagePath = request.getServletPath() + request.getPathInfo();
        this.setQueryMap(request.getParameterMap());
        this.extension = ResponseUtils.getExtension((String)this.pagePath);
        if (this.extension != null) {
            this.pagePath = this.pagePath.substring(0, this.pagePath.length() - this.extension.length() - 1);
        }
        if (this.pagePath.endsWith("/")) {
            this.pagePath = this.pagePath.substring(0, this.pagePath.length() - 1);
        }
    }

    private void setQueryMap(Map<String, String[]> parameterMap) {
        this.queryMap = parameterMap;
    }

    public String getBaseURL() {
        return this.baseURL;
    }

    public void setBaseURL(String baseURL) {
        this.baseURL = baseURL;
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public void setServletPath(String servletPath) {
        this.servletPath = servletPath;
    }

    public String getPagePath() {
        return this.pagePath;
    }

    public void setPagePath(String pagePath) {
        this.pagePath = pagePath;
    }

    public String getExtension() {
        return this.extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public String pageURI(String path) {
        return this.buildURI(this.pagePath, path);
    }

    public String servletURI(String path) {
        return this.buildURI(this.servletPath, path);
    }

    String buildURI(String base, String path) {
        if (path != null) {
            if (path.startsWith(".")) {
                if (base.endsWith("/")) {
                    base = base.substring(1);
                }
                path = base + path;
            } else {
                path = ResponseUtils.appendPath((String[])new String[]{base, path});
            }
        }
        return ResponseUtils.buildURL((String)this.baseURL, (String)path, null, (URLMangler.URLType)URLMangler.URLType.SERVICE);
    }

    public static RequestInfo get() {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (requestAttributes == null) {
            return null;
        }
        return (RequestInfo)requestAttributes.getAttribute(KEY, 0);
    }

    public Map<String, String[]> getQueryMap() {
        return this.queryMap;
    }

    public static void set(RequestInfo requestInfo) {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (requestAttributes == null) {
            throw new IllegalStateException("Request attributes are not set");
        }
        requestAttributes.setAttribute(KEY, (Object)requestInfo, 0);
    }
}

