/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest;

import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.SimpleHash;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.geoserver.rest.RequestInfo;
import org.geoserver.rest.RestBaseController;
import org.geoserver.rest.wrapper.RestWrapper;
import org.geoserver.template.TemplateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

@RestController
@RequestMapping(path={"/rest"}, produces={"application/json", "application/xml", "text/html"})
public class IndexController
extends RestBaseController {
    @Autowired
    private RequestMappingHandlerMapping requestMappingHandlerMapping;

    @GetMapping(value={"", "index"}, produces={"text/html"})
    public RestWrapper get() {
        SimpleHash model = new SimpleHash((ObjectWrapper)new DefaultObjectWrapper(TemplateUtils.FM_VERSION));
        model.put("links", this.getLinks());
        model.put("page", (Object)RequestInfo.get());
        return this.wrapObject(model, SimpleHash.class);
    }

    protected Set<String> getLinks() {
        TreeSet<String> s = new TreeSet<String>();
        Map handlerMethods = this.requestMappingHandlerMapping.getHandlerMethods();
        for (Map.Entry item : handlerMethods.entrySet()) {
            RequestMappingInfo mapping = (RequestMappingInfo)item.getKey();
            if (!mapping.getMethodsCondition().getMethods().contains(RequestMethod.GET)) continue;
            for (String pattern : mapping.getPatternsCondition().getPatterns()) {
                if (pattern.contains("{")) continue;
                String path = pattern;
                int rootSize = "/rest".length() + 1;
                if (!path.startsWith("/rest") || path.length() <= rootSize) continue;
                if ((path = path.substring(rootSize)).endsWith("/**")) {
                    path = path.substring(0, path.length() - 3);
                }
                if (path.length() <= 0) continue;
                s.add(path);
            }
        }
        return s;
    }

    @Override
    public String getTemplateName(Object o) {
        return "index";
    }
}

