/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest.system.status;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import freemarker.template.ObjectWrapper;
import java.util.Arrays;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.geoserver.config.util.XStreamPersister;
import org.geoserver.rest.ObjectToMapWrapper;
import org.geoserver.rest.RestBaseController;
import org.geoserver.rest.converters.XStreamMessageConverter;
import org.geoserver.rest.wrapper.RestWrapper;
import org.geoserver.system.status.MetricValue;
import org.geoserver.system.status.Metrics;
import org.geoserver.system.status.SystemInfoCollector;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"/rest/about/system-status"})
public class MonitorRest
extends RestBaseController {
    @Autowired
    SystemInfoCollector systemInfoCollector;

    @GetMapping(value={""}, produces={"application/json", "application/xml", "text/html"})
    @ResponseStatus(value=HttpStatus.OK)
    public RestWrapper<Metrics> getData(HttpServletRequest request, HttpServletResponse response) {
        Metrics si = this.systemInfoCollector.retrieveAllSystemInfo();
        return this.wrapObject(si, Metrics.class);
    }

    public void configurePersister(XStreamPersister persister, XStreamMessageConverter converter) {
        XStream xs = persister.getXStream();
        xs.alias("metric", MetricValue.class);
        xs.alias("metrics", Metrics.class);
        xs.omitField(MetricValue.class, "value");
        xs.registerConverter((Converter)new ValueHolderConverter());
        xs.aliasField("value", MetricValue.class, "holder");
        xs.addImplicitCollection(Metrics.class, "metrics");
    }

    protected <T> ObjectWrapper createObjectWrapper(Class<T> clazz) {
        return new ObjectToMapWrapper(clazz, Arrays.asList(MetricValue.class));
    }

    private static final class ValueHolderConverter
    implements Converter {
        private ValueHolderConverter() {
        }

        public boolean canConvert(Class type) {
            return MetricValue.ValueHolder.class.isAssignableFrom(type);
        }

        public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
            Object value = ((MetricValue.ValueHolder)source).getValue();
            writer.setValue(value != null ? value.toString() : "");
        }

        public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
            return null;
        }
    }
}

