/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest.service;

import freemarker.template.ObjectWrapper;
import java.util.Collections;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.config.ServiceInfo;
import org.geoserver.ows.util.OwsUtils;
import org.geoserver.rest.AbstractGeoServerController;
import org.geoserver.rest.ObjectToMapWrapper;
import org.geoserver.rest.RestException;
import org.geoserver.rest.wrapper.RestWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;

public abstract class ServiceSettingsController<T extends ServiceInfo>
extends AbstractGeoServerController {
    private Class<T> clazz;

    @Autowired
    public ServiceSettingsController(@Qualifier(value="geoServer") GeoServer geoServer, Class<T> clazz) {
        super(geoServer);
        this.clazz = clazz;
    }

    @GetMapping(value={"/settings", "/workspaces/{workspaceName}/settings"}, produces={"application/json", "application/xml", "text/html"})
    public RestWrapper serviceSettingsGet(@PathVariable(required=false) String workspaceName) {
        ServiceInfo service;
        if (workspaceName != null) {
            WorkspaceInfo ws = this.geoServer.getCatalog().getWorkspaceByName(workspaceName);
            if (ws == null) {
                throw new RestException("Workspace " + workspaceName + " does not exist", HttpStatus.NOT_FOUND);
            }
            service = this.geoServer.getService(ws, this.clazz);
        } else {
            service = this.geoServer.getService(this.clazz);
        }
        if (service == null) {
            String errorMessage = "Service does not exist" + (workspaceName == null ? "" : " for workspace " + workspaceName);
            throw new RestException(errorMessage, HttpStatus.NOT_FOUND);
        }
        return this.wrapObject(service, this.clazz);
    }

    public void serviceSettingsPut(T info, String workspaceName) {
        ServiceInfo originalInfo;
        WorkspaceInfo ws = null;
        if (workspaceName != null) {
            ws = this.geoServer.getCatalog().getWorkspaceByName(workspaceName);
        }
        if ((originalInfo = ws != null ? this.geoServer.getService(ws, this.clazz) : this.geoServer.getService(this.clazz)) != null) {
            OwsUtils.copy(info, (Object)originalInfo, this.clazz);
            this.geoServer.save(originalInfo);
        } else {
            if (ws != null) {
                info.setWorkspace(ws);
            }
            this.geoServer.add(info);
        }
    }

    @DeleteMapping(value={"/workspaces/{workspaceName}/settings"})
    public void serviceDelete(@PathVariable String workspaceName) {
        WorkspaceInfo ws = this.geoServer.getCatalog().getWorkspaceByName(workspaceName);
        if (ws == null) {
            throw new RestException("Workspace " + workspaceName + " does not exist", HttpStatus.NOT_FOUND);
        }
        ServiceInfo serviceInfo = this.geoServer.getService(ws, this.clazz);
        if (serviceInfo != null) {
            this.geoServer.remove(serviceInfo);
        }
    }

    protected <T> ObjectWrapper createObjectWrapper(Class<T> clazz) {
        return new ObjectToMapWrapper(clazz, Collections.singletonList(WorkspaceInfo.class));
    }
}

