/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest.security.xml;

import java.io.IOException;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.geoserver.security.GeoServerUserGroupService;
import org.geoserver.security.impl.GeoServerUser;

@XmlRootElement(name="user")
public class JaxbUser {
    protected String userName;
    protected String password;
    protected Boolean enabled;

    public JaxbUser() {
    }

    public JaxbUser(GeoServerUser user) {
        this.userName = user.getUsername();
        this.enabled = user.isEnabled();
    }

    @XmlElement
    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    @XmlElement
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String passwd) {
        this.password = passwd;
    }

    @XmlElement
    public Boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public GeoServerUser toUser(GeoServerUserGroupService service) throws IOException {
        return service.createUserObject(this.userName, this.password, this.enabled.booleanValue());
    }

    public GeoServerUser toUser(GeoServerUser user) {
        if (this.password != null) {
            user.setPassword(this.password);
        }
        if (this.enabled != null) {
            user.setEnabled(this.enabled.booleanValue());
        }
        return user;
    }

    public String toString() {
        return "JaxbUser{userName='" + this.userName + '\'' + ", password='" + this.password + '\'' + ", enabled=" + this.enabled + '}';
    }
}

