/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest.security;

import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import org.geoserver.rest.catalog.SequentialExecutionController;
import org.geoserver.rest.security.xml.JaxbGroupList;
import org.geoserver.rest.security.xml.JaxbUser;
import org.geoserver.rest.security.xml.JaxbUserList;
import org.geoserver.security.GeoServerSecurityManager;
import org.geoserver.security.GeoServerUserGroupService;
import org.geoserver.security.GeoServerUserGroupStore;
import org.geoserver.security.impl.GeoServerUser;
import org.geoserver.security.impl.GeoServerUserGroup;
import org.geoserver.security.validation.PasswordPolicyException;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="usergroupRestController")
@RequestMapping(path={"/rest/security/usergroup"})
public class UsersRestController
implements SequentialExecutionController {
    protected GeoServerSecurityManager securityManager;
    private static final String DEFAULT_ROLE_SERVICE_NAME = "default";

    private String getDefaultServiceName() {
        String defaultServiceName = System.getProperty("org.geoserver.rest.DefaultUserGroupServiceName");
        return defaultServiceName == null ? DEFAULT_ROLE_SERVICE_NAME : defaultServiceName;
    }

    public UsersRestController(GeoServerSecurityManager securityManager) {
        this.securityManager = securityManager;
    }

    @ExceptionHandler(value={IllegalArgumentException.class})
    public void somethingNotFound(IllegalArgumentException exception, HttpServletResponse response) throws IOException {
        response.sendError(404, exception.getMessage());
    }

    @GetMapping(value={"/users"}, produces={"application/xml", "application/json"})
    public JaxbUserList getUsers() throws IOException {
        return this.getUsers(this.getDefaultServiceName());
    }

    @GetMapping(value={"/groups"}, produces={"application/xml", "application/json"})
    public JaxbGroupList getGroups() throws IOException {
        return this.getGroups(this.getDefaultServiceName());
    }

    @GetMapping(value={"/group/{group}/users"}, produces={"application/xml", "application/json"})
    public JaxbUserList getUsersFromGroup(@PathVariable(value="group") String groupName) throws IOException {
        return this.getUsersFromGroup(this.getDefaultServiceName(), groupName);
    }

    @GetMapping(value={"/user/{user}/groups"}, produces={"application/xml", "application/json"})
    public JaxbGroupList getGroupsFromUser(@PathVariable(value="user") String userName) throws IOException {
        return this.getGroupsFromUser(this.getDefaultServiceName(), userName);
    }

    @PostMapping(value={"/users"})
    @ResponseStatus(value=HttpStatus.CREATED)
    public void insertUser(@RequestBody JaxbUser user) throws PasswordPolicyException, IOException {
        this.insertUser(this.getDefaultServiceName(), user);
    }

    @PostMapping(value={"/user/{user}"})
    @ResponseStatus(value=HttpStatus.OK)
    public void updateUser(@PathVariable(value="user") String userName, @RequestBody JaxbUser user) throws PasswordPolicyException, IOException {
        this.updateUser(this.getDefaultServiceName(), userName, user);
    }

    @DeleteMapping(value={"/user/{user}"})
    @ResponseStatus(value=HttpStatus.OK)
    public void deleteUser(@PathVariable(value="user") String userName) throws IOException {
        this.deleteUser(this.getDefaultServiceName(), userName);
    }

    @PostMapping(value={"/group/{group}"})
    @ResponseStatus(value=HttpStatus.CREATED)
    public void insertGroup(@PathVariable(value="group") String groupName) throws PasswordPolicyException, IOException {
        this.insertGroup(this.getDefaultServiceName(), groupName);
    }

    @DeleteMapping(value={"/group/{group}"})
    @ResponseStatus(value=HttpStatus.OK)
    public void deleteGroup(@PathVariable(value="group") String groupName) throws IOException {
        this.deleteGroup(this.getDefaultServiceName(), groupName);
    }

    @PostMapping(value={"/user/{user}/group/{group}"})
    @ResponseStatus(value=HttpStatus.OK)
    public void associateUserToGroup(@PathVariable(value="user") String userName, @PathVariable(value="group") String groupName) throws IOException {
        this.associateUserToGroup(this.getDefaultServiceName(), userName, groupName);
    }

    @DeleteMapping(value={"/user/{user}/group/{group}"})
    @ResponseStatus(value=HttpStatus.OK)
    public void disassociateUserFromGroup(@PathVariable(value="user") String userName, @PathVariable(value="group") String groupName) throws IOException {
        this.disassociateUserFromGroup(this.getDefaultServiceName(), userName, groupName);
    }

    @GetMapping(value={"/service/{serviceName}/users"}, produces={"application/xml", "application/json"})
    public JaxbUserList getUsers(@PathVariable(value="serviceName") String serviceName) throws IOException {
        return new JaxbUserList(this.getService(serviceName).getUsers());
    }

    @GetMapping(value={"/service/{serviceName}/groups"}, produces={"application/xml", "application/json"})
    public JaxbGroupList getGroups(@PathVariable(value="serviceName") String serviceName) throws IOException {
        return new JaxbGroupList(this.getService(serviceName).getUserGroups());
    }

    @GetMapping(value={"/service/{serviceName}/group/{group}/users"}, produces={"application/xml", "application/json"})
    public JaxbUserList getUsersFromGroup(@PathVariable(value="serviceName") String serviceName, @PathVariable(value="group") String groupName) throws IOException {
        GeoServerUserGroupService service = this.getService(serviceName);
        return new JaxbUserList(service.getUsersForGroup(this.getGroup(service, groupName)));
    }

    @GetMapping(value={"/service/{serviceName}/user/{user}/groups"}, produces={"application/xml", "application/json"})
    public JaxbGroupList getGroupsFromUser(@PathVariable(value="serviceName") String serviceName, @PathVariable(value="user") String userName) throws IOException {
        GeoServerUserGroupService service = this.getService(serviceName);
        return new JaxbGroupList(service.getGroupsForUser(this.getUser(service, userName)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"/service/{serviceName}/users"})
    @ResponseStatus(value=HttpStatus.CREATED)
    public void insertUser(@PathVariable(value="serviceName") String serviceName, @RequestBody JaxbUser user) throws PasswordPolicyException, IOException {
        GeoServerUserGroupStore store = this.getStore(serviceName);
        try {
            store.addUser(user.toUser((GeoServerUserGroupService)store));
        }
        finally {
            store.store();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"/service/{serviceName}/user/{user}"})
    @ResponseStatus(value=HttpStatus.OK)
    public void updateUser(@PathVariable(value="serviceName") String serviceName, @PathVariable(value="user") String userName, @RequestBody JaxbUser user) throws PasswordPolicyException, IOException {
        GeoServerUserGroupStore store = this.getStore(serviceName);
        try {
            store.updateUser(user.toUser(this.getUser((GeoServerUserGroupService)store, userName)));
        }
        finally {
            store.store();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DeleteMapping(value={"/service/{serviceName}/user/{user}"})
    @ResponseStatus(value=HttpStatus.OK)
    public void deleteUser(@PathVariable(value="serviceName") String serviceName, @PathVariable(value="user") String userName) throws IOException {
        GeoServerUserGroupStore store = this.getStore(serviceName);
        try {
            store.removeUser(this.getUser((GeoServerUserGroupService)store, userName));
        }
        finally {
            store.store();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"/service/{serviceName}/group/{group}"})
    @ResponseStatus(value=HttpStatus.CREATED)
    public void insertGroup(@PathVariable(value="serviceName") String serviceName, @PathVariable(value="group") String groupName) throws PasswordPolicyException, IOException {
        GeoServerUserGroupStore store = this.getStore(serviceName);
        try {
            store.addGroup(new GeoServerUserGroup(groupName));
        }
        finally {
            store.store();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DeleteMapping(value={"/service/{serviceName}/group/{group}"})
    @ResponseStatus(value=HttpStatus.OK)
    public void deleteGroup(@PathVariable(value="serviceName") String serviceName, @PathVariable(value="group") String groupName) throws IOException {
        GeoServerUserGroupStore store = this.getStore(serviceName);
        try {
            store.removeGroup(this.getGroup((GeoServerUserGroupService)store, groupName));
        }
        finally {
            store.store();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"/service/{serviceName}/user/{user}/group/{group}"})
    @ResponseStatus(value=HttpStatus.OK)
    public void associateUserToGroup(@PathVariable(value="serviceName") String serviceName, @PathVariable(value="user") String userName, @PathVariable(value="group") String groupName) throws IOException {
        GeoServerUserGroupStore store = this.getStore(serviceName);
        try {
            store.associateUserToGroup(this.getUser((GeoServerUserGroupService)store, userName), this.getGroup((GeoServerUserGroupService)store, groupName));
        }
        finally {
            store.store();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DeleteMapping(value={"/service/{serviceName}/user/{user}/group/{group}"})
    @ResponseStatus(value=HttpStatus.OK)
    public void disassociateUserFromGroup(@PathVariable(value="serviceName") String serviceName, @PathVariable(value="user") String userName, @PathVariable(value="group") String groupName) throws IOException {
        GeoServerUserGroupStore store = this.getStore(serviceName);
        try {
            store.disAssociateUserFromGroup(this.getUser((GeoServerUserGroupService)store, userName), this.getGroup((GeoServerUserGroupService)store, groupName));
        }
        finally {
            store.store();
        }
    }

    protected GeoServerUserGroupService getService(String serviceName) throws IOException {
        GeoServerUserGroupService service = this.securityManager.loadUserGroupService(serviceName);
        if (service == null) {
            throw new IllegalArgumentException("Provided user/group service does not exist: " + serviceName);
        }
        return this.securityManager.loadUserGroupService(serviceName);
    }

    protected GeoServerUserGroupStore getStore(String serviceName) throws IOException {
        GeoServerUserGroupService service = this.securityManager.loadUserGroupService(serviceName);
        if (service == null) {
            throw new IllegalArgumentException("Provided user/group service does not exist: " + serviceName);
        }
        if (service.canCreateStore()) {
            return this.securityManager.loadUserGroupService(serviceName).createStore();
        }
        throw new IOException("Provided UserGroupService is read-only.");
    }

    protected GeoServerUser getUser(GeoServerUserGroupService service, String userName) throws IOException {
        GeoServerUser user = service.getUserByUsername(userName);
        if (user == null) {
            throw new IllegalArgumentException("Provided username does not exist: " + userName);
        }
        return user;
    }

    protected GeoServerUserGroup getGroup(GeoServerUserGroupService service, String groupName) throws IOException {
        GeoServerUserGroup group = service.getGroupByGroupname(groupName);
        if (group == null) {
            throw new IllegalArgumentException("Provided groupname does not exist: " + groupName);
        }
        return group;
    }
}

