/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest.security;

import java.util.Map;
import org.geoserver.rest.catalog.MapXMLConverter;
import org.geoserver.rest.security.RuleMap;
import org.springframework.stereotype.Component;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Component
public class RuleMapXMLConverter
extends MapXMLConverter {
    static final String ROOTELEMENT = "rules";
    static final String RULEELEMENT = "rule";
    static final String RESOURCEATTR = "resource";

    public int getPriority() {
        return 50;
    }

    @Override
    protected boolean supports(Class<?> clazz) {
        return RuleMap.class.isAssignableFrom(clazz);
    }

    @Override
    protected String getMapName(Map<?, ?> map) {
        return ROOTELEMENT;
    }

    @Override
    protected final void insert(Element elem, Object o) {
        if (o instanceof RuleMap) {
            Map ruleMap = (Map)o;
            for (Map.Entry entry : ruleMap.entrySet()) {
                Element ruleElement = elem.getOwnerDocument().createElement(RULEELEMENT);
                ruleElement.setAttribute(RESOURCEATTR, (String)entry.getKey());
                ruleElement.setTextContent((String)entry.getValue());
                elem.appendChild(ruleElement);
            }
        } else {
            throw new IllegalArgumentException();
        }
    }

    @Override
    protected Map<String, String> convert(Element elem) {
        RuleMap<String, String> ruleMap = new RuleMap<String, String>();
        NodeList children = elem.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node n = children.item(i);
            if (!(n instanceof Element)) continue;
            Element ruleElement = (Element)n;
            String resource = ruleElement.getAttribute(RESOURCEATTR);
            ruleMap.put(resource, ruleElement.getTextContent());
        }
        return ruleMap;
    }
}

