/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest.catalog;

import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import freemarker.template.ObjectWrapper;
import freemarker.template.SimpleHash;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.geoserver.catalog.CascadeDeleteVisitor;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.WMSLayerInfo;
import org.geoserver.catalog.WMSStoreInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.config.util.XStreamPersister;
import org.geoserver.rest.ObjectToMapWrapper;
import org.geoserver.rest.ResourceNotFoundException;
import org.geoserver.rest.RestException;
import org.geoserver.rest.catalog.AbstractCatalogController;
import org.geoserver.rest.converters.XStreamMessageConverter;
import org.geoserver.rest.wrapper.RestWrapper;
import org.geotools.util.logging.Logging;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.MethodParameter;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

@RestController
@ControllerAdvice
@RequestMapping(path={"/rest/workspaces/{workspaceName}/wmsstores"})
public class WMSStoreController
extends AbstractCatalogController {
    private static final Logger LOGGER = Logging.getLogger(WMSStoreController.class);

    @Autowired
    public WMSStoreController(@Qualifier(value="catalog") Catalog catalog) {
        super(catalog);
    }

    @GetMapping(produces={"application/json", "application/xml", "text/html"})
    public RestWrapper<WMSStoreInfo> wmsStoresGet(@PathVariable String workspaceName) {
        List wmsStores = this.catalog.getStoresByWorkspace(workspaceName, WMSStoreInfo.class);
        return this.wrapList(wmsStores, WMSStoreInfo.class);
    }

    @GetMapping(path={"/{storeName}"}, produces={"application/json", "application/xml", "text/html"})
    public RestWrapper<WMSStoreInfo> wmsStoreGet(@PathVariable String workspaceName, @PathVariable String storeName) {
        WMSStoreInfo wmsStore = this.getExistingWMSStore(workspaceName, storeName);
        return this.wrapObject(wmsStore, WMSStoreInfo.class);
    }

    @PostMapping(consumes={"application/json", "text/json", "application/xml", "text/xml"})
    public ResponseEntity<String> wmsStorePost(@RequestBody WMSStoreInfo wmsStore, @PathVariable String workspaceName, UriComponentsBuilder builder) {
        if (wmsStore.getWorkspace() != null) {
            WorkspaceInfo ws = wmsStore.getWorkspace();
            if (!workspaceName.equals(ws.getName())) {
                throw new RestException("Expected workspace " + workspaceName + " but client specified " + ws.getName(), HttpStatus.FORBIDDEN);
            }
        } else {
            wmsStore.setWorkspace(this.catalog.getWorkspaceByName(workspaceName));
        }
        wmsStore.setEnabled(true);
        this.catalog.validate((StoreInfo)wmsStore, false).throwIfInvalid();
        this.catalog.add((StoreInfo)wmsStore);
        String storeName = wmsStore.getName();
        LOGGER.info("POST wms store " + storeName);
        UriComponents uriComponents = builder.path("/workspaces/{workspaceName}/wmsstores/{storeName}").buildAndExpand(new Object[]{workspaceName, storeName});
        HttpHeaders headers = new HttpHeaders();
        headers.setLocation(uriComponents.toUri());
        headers.setContentType(MediaType.TEXT_PLAIN);
        return new ResponseEntity((Object)storeName, (MultiValueMap)headers, HttpStatus.CREATED);
    }

    @PutMapping(value={"/{storeName}"}, consumes={"application/json", "text/json", "application/xml", "text/xml"})
    public void wmsStorePut(@RequestBody WMSStoreInfo info, @PathVariable String workspaceName, @PathVariable String storeName) {
        WMSStoreInfo original = this.getExistingWMSStore(workspaceName, storeName);
        if (info.getWorkspace() != null && !original.getWorkspace().equals(info.getWorkspace())) {
            throw new RestException("Attempting to move " + storeName + " from " + original.getWorkspace().getName() + " to " + info.getWorkspace().getName() + " via PUT", HttpStatus.FORBIDDEN);
        }
        if (!original.getName().equals(info.getName())) {
            throw new RestException("Attempting to rename " + storeName + " to " + info.getName() + " via PUT", HttpStatus.FORBIDDEN);
        }
        new CatalogBuilder(this.catalog).updateWMSStore(original, info);
        this.catalog.validate((StoreInfo)original, false).throwIfInvalid();
        this.catalog.save((StoreInfo)original);
        this.clear(original);
        LOGGER.info("PUT wms store " + workspaceName + "," + storeName);
    }

    private WMSStoreInfo getExistingWMSStore(String workspaceName, String storeName) {
        WMSStoreInfo original = (WMSStoreInfo)this.catalog.getStoreByName(workspaceName, storeName, WMSStoreInfo.class);
        if (original == null) {
            throw new ResourceNotFoundException("No such wms store: " + workspaceName + "," + storeName);
        }
        return original;
    }

    @DeleteMapping(value={"/{storeName}"})
    public void wmsStoreDelete(@PathVariable String workspaceName, @PathVariable String storeName, @RequestParam(name="recurse", required=false, defaultValue="false") boolean recurse) throws IOException {
        WMSStoreInfo cs = this.getExistingWMSStore(workspaceName, storeName);
        if (!recurse) {
            if (!this.catalog.getResourcesByStore((StoreInfo)cs, WMSLayerInfo.class).isEmpty()) {
                throw new RestException("wmsstore not empty", HttpStatus.UNAUTHORIZED);
            }
            this.catalog.remove((StoreInfo)cs);
        } else {
            new CascadeDeleteVisitor(this.catalog).visit(cs);
        }
        this.clear(cs);
        LOGGER.info("DELETE wms store " + workspaceName + ":s" + workspaceName);
    }

    void clear(WMSStoreInfo info) {
        this.catalog.getResourcePool().clear(info);
    }

    public boolean supports(MethodParameter methodParameter, Type targetType, Class<? extends HttpMessageConverter<?>> converterType) {
        return WMSStoreInfo.class.isAssignableFrom(methodParameter.getParameterType());
    }

    public void configurePersister(XStreamPersister persister, final XStreamMessageConverter converter) {
        persister.setCallback(new XStreamPersister.Callback(){

            protected Class<WMSStoreInfo> getObjectClass() {
                return WMSStoreInfo.class;
            }

            protected CatalogInfo getCatalogObject() {
                Map uriTemplateVars = WMSStoreController.this.getURITemplateVariables();
                String workspace = (String)uriTemplateVars.get("workspaceName");
                String store = (String)uriTemplateVars.get("storeName");
                if (workspace == null || store == null) {
                    return null;
                }
                return WMSStoreController.this.catalog.getStoreByName(workspace, store, WMSStoreInfo.class);
            }

            protected void postEncodeWMSStore(WMSStoreInfo cs, HierarchicalStreamWriter writer, MarshallingContext context) {
                writer.startNode("wmslayers");
                converter.encodeCollectionLink("wmslayers", writer);
                writer.endNode();
            }

            protected void postEncodeReference(Object obj, String ref, String prefix, HierarchicalStreamWriter writer, MarshallingContext context) {
                if (obj instanceof WorkspaceInfo) {
                    converter.encodeLink("/workspaces/" + converter.encode(ref), writer);
                }
            }
        });
    }

    protected <T> ObjectWrapper createObjectWrapper(Class<T> clazz) {
        return new ObjectToMapWrapper<WMSStoreInfo>(WMSStoreInfo.class){

            protected void wrapInternal(Map<String, Object> properties, SimpleHash model, WMSStoreInfo store) {
                if (properties == null) {
                    properties = this.hashToProperties(model);
                }
                ArrayList dsProps = new ArrayList();
                List resources = WMSStoreController.this.catalog.getResourcesByStore((StoreInfo)store, WMSLayerInfo.class);
                for (WMSLayerInfo resource : resources) {
                    HashMap<String, String> names = new HashMap<String, String>();
                    names.put("name", resource.getName());
                    dsProps.add(Collections.singletonMap("properties", names));
                }
                if (!dsProps.isEmpty()) {
                    properties.putIfAbsent("wmsLayers", dsProps);
                }
            }

            protected void wrapInternal(SimpleHash model, Collection object) {
                for (Object w : object) {
                    WMSStoreInfo wk = (WMSStoreInfo)w;
                    this.wrapInternal(null, model, wk);
                }
            }
        };
    }
}

