/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest.catalog;

import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import freemarker.template.ObjectWrapper;
import freemarker.template.SimpleHash;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.catalog.AttributeTypeInfo;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.MetadataMap;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.config.util.XStreamPersister;
import org.geoserver.rest.ObjectToMapWrapper;
import org.geoserver.rest.ResourceNotFoundException;
import org.geoserver.rest.RestException;
import org.geoserver.rest.catalog.AbstractCatalogController;
import org.geoserver.rest.catalog.CoverageStoreController;
import org.geoserver.rest.catalog.StringsList;
import org.geoserver.rest.converters.XStreamMessageConverter;
import org.geoserver.rest.wrapper.RestWrapper;
import org.geotools.data.DataAccess;
import org.geotools.data.DataStore;
import org.geotools.data.FeatureSource;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.MethodParameter;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

@RestController
@ControllerAdvice
@RequestMapping(path={"/rest/workspaces/{workspaceName}/featuretypes", "/rest/workspaces/{workspaceName}/datastores/{storeName}/featuretypes"})
public class FeatureTypeController
extends AbstractCatalogController {
    private static final Logger LOGGER = Logging.getLogger(CoverageStoreController.class);

    @Autowired
    public FeatureTypeController(@Qualifier(value="catalog") Catalog catalog) {
        super(catalog);
    }

    @GetMapping(produces={"text/html", "application/json", "application/xml"})
    public Object featureTypesGet(@PathVariable String workspaceName, @PathVariable(required=false) String storeName, @RequestParam(defaultValue="configured") String list) {
        List fts;
        if ("available".equalsIgnoreCase(list) || "available_with_geom".equalsIgnoreCase(list) || "all".equalsIgnoreCase(list)) {
            DataStoreInfo info = this.getExistingDataStore(workspaceName, storeName);
            boolean skipNoGeom = "available_with_geom".equalsIgnoreCase(list);
            ArrayList<String> featureTypes = new ArrayList<String>();
            try {
                String[] featureTypeNames;
                DataStore ds = (DataStore)info.getDataStore(null);
                for (String featureTypeName : featureTypeNames = ds.getTypeNames()) {
                    FeatureTypeInfo ftinfo = this.catalog.getFeatureTypeByDataStore(info, featureTypeName);
                    if (ftinfo == null) {
                        if (skipNoGeom) {
                            try {
                                SimpleFeatureType featureType = ds.getSchema(featureTypeName);
                                if (featureType.getGeometryDescriptor() == null) {
                                    continue;
                                }
                            }
                            catch (IOException e) {
                                LOGGER.log(Level.WARNING, "Unable to load schema for feature type " + featureTypeName, e);
                            }
                        }
                        featureTypes.add(featureTypeName);
                        continue;
                    }
                    if (!"all".equalsIgnoreCase(list)) continue;
                    featureTypes.add(featureTypeName);
                }
            }
            catch (IOException e) {
                throw new ResourceNotFoundException("Could not load datastore: " + storeName);
            }
            return new StringsList(featureTypes, "featureTypeName");
        }
        if (storeName != null) {
            DataStoreInfo dataStore = this.catalog.getDataStoreByName(workspaceName, storeName);
            fts = this.catalog.getFeatureTypesByDataStore(dataStore);
        } else {
            NamespaceInfo ns = this.catalog.getNamespaceByPrefix(workspaceName);
            fts = this.catalog.getFeatureTypesByNamespace(ns);
        }
        return this.wrapList(fts, FeatureTypeInfo.class);
    }

    @PostMapping(consumes={"text/json", "application/json", "text/xml", "application/xml"})
    public ResponseEntity featureTypePost(@PathVariable String workspaceName, @PathVariable(required=false) String storeName, @RequestBody FeatureTypeInfo ftInfo, UriComponentsBuilder builder) throws Exception {
        NamespaceInfo ns;
        DataStoreInfo dsInfo = this.getExistingDataStore(workspaceName, storeName);
        if (ftInfo.getStore() != null && storeName != null) {
            if (!storeName.equals(ftInfo.getStore().getName())) {
                throw new RestException("Expected datastore " + storeName + " but client specified " + ftInfo.getStore().getName(), HttpStatus.FORBIDDEN);
            }
            ftInfo.setStore((StoreInfo)dsInfo);
        } else {
            ftInfo.setStore((StoreInfo)dsInfo);
        }
        if (ftInfo.getNamespace() != null) {
            if (!workspaceName.equals(ftInfo.getNamespace().getPrefix())) {
                throw new RestException("Expected workspace " + workspaceName + " but client specified " + ftInfo.getNamespace().getPrefix(), HttpStatus.FORBIDDEN);
            }
        } else {
            ftInfo.setNamespace(this.catalog.getNamespaceByPrefix(workspaceName));
        }
        ftInfo.setEnabled(true);
        DataAccess dataAccess = dsInfo.getDataStore(null);
        if (dataAccess instanceof DataStore) {
            MetadataMap mdm;
            boolean virtual;
            String typeName = ftInfo.getName();
            if (ftInfo.getNativeName() != null) {
                typeName = ftInfo.getNativeName();
            }
            boolean typeExists = false;
            DataStore dataStore = (DataStore)dataAccess;
            for (String name : dataStore.getTypeNames()) {
                if (!name.equals(typeName)) continue;
                typeExists = true;
                break;
            }
            boolean bl = virtual = (mdm = ftInfo.getMetadata()) != null && mdm.containsKey((Object)"JDBC_VIRTUAL_TABLE");
            if (!virtual && !typeExists) {
                dataStore.createSchema((FeatureType)this.buildFeatureType(ftInfo));
                ftInfo.getAttributes().clear();
                List<String> typeNames = Arrays.asList(dataStore.getTypeNames());
                if (!typeNames.contains(typeName) && typeNames.contains(typeName.toUpperCase())) {
                    ftInfo.setNativeName(ftInfo.getName().toLowerCase());
                }
            }
        }
        CatalogBuilder cb = new CatalogBuilder(this.catalog);
        cb.initFeatureType(ftInfo);
        try {
            FeatureSource featureSource = dataAccess.getFeatureSource(ftInfo.getQualifiedNativeName());
            if (featureSource != null) {
                cb.setupMetadata(ftInfo, featureSource);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Unable to fill in metadata from underlying feature source", e);
        }
        if (ftInfo.getStore() == null) {
            ftInfo.setStore((StoreInfo)dsInfo);
        }
        if ((ns = ftInfo.getNamespace()) != null && !ns.getPrefix().equals(workspaceName)) {
            LOGGER.warning("Namespace: " + ns.getPrefix() + " does not match workspace: " + workspaceName + ", overriding.");
            ns = null;
        }
        if (ns == null) {
            ns = this.catalog.getNamespaceByPrefix(workspaceName);
            ftInfo.setNamespace(ns);
        }
        ftInfo.setEnabled(true);
        this.catalog.validate((ResourceInfo)ftInfo, true).throwIfInvalid();
        this.catalog.add((ResourceInfo)ftInfo);
        this.catalog.add(new CatalogBuilder(this.catalog).buildLayer(ftInfo));
        LOGGER.info("POST feature type" + storeName + "," + ftInfo.getName());
        UriComponents uriComponents = storeName == null ? builder.path("/workspaces/{workspaceName}/featuretypes/{featureTypeName}").buildAndExpand(new Object[]{workspaceName, ftInfo.getName()}) : builder.path("/workspaces/{workspaceName}/datastores/{storeName}/featuretypes/{featureTypeName}").buildAndExpand(new Object[]{workspaceName, storeName, ftInfo.getName()});
        HttpHeaders headers = new HttpHeaders();
        headers.setLocation(uriComponents.toUri());
        headers.setContentType(MediaType.TEXT_PLAIN);
        return new ResponseEntity((Object)"", (MultiValueMap)headers, HttpStatus.CREATED);
    }

    @GetMapping(path={"/{featureTypeName}"}, produces={"text/html", "application/json", "application/xml"})
    public RestWrapper featureTypeGet(@PathVariable String workspaceName, @PathVariable(required=false) String storeName, @PathVariable String featureTypeName, @RequestParam(name="quietOnNotFound", required=false, defaultValue="false") Boolean quietOnNotFound) {
        FeatureTypeInfo ftInfo;
        if (storeName != null) {
            DataStoreInfo dsInfo = this.getExistingDataStore(workspaceName, storeName);
            ftInfo = this.catalog.getFeatureTypeByDataStore(dsInfo, featureTypeName);
        } else {
            NamespaceInfo ns = this.catalog.getNamespaceByPrefix(workspaceName);
            ftInfo = this.catalog.getFeatureTypeByName(ns, featureTypeName);
        }
        this.checkFeatureTypeExists(ftInfo, workspaceName, storeName, featureTypeName);
        return this.wrapObject(ftInfo, FeatureTypeInfo.class);
    }

    @PutMapping(path={"/{featureTypeName}"}, produces={"text/html", "application/json", "application/xml"})
    public void featureTypePut(@PathVariable String workspaceName, @PathVariable(required=false) String storeName, @PathVariable String featureTypeName, @RequestBody FeatureTypeInfo featureTypeUpdate, @RequestParam(name="recalculate", required=false) String recalculate) {
        boolean virtual;
        DataStoreInfo dsInfo = this.getExistingDataStore(workspaceName, storeName);
        FeatureTypeInfo ftInfo = this.catalog.getFeatureTypeByDataStore(dsInfo, featureTypeName);
        this.checkFeatureTypeExists(ftInfo, workspaceName, storeName, featureTypeName);
        Map parametersCheck = ftInfo.getStore().getConnectionParameters();
        this.calculateOptionalFields((ResourceInfo)featureTypeUpdate, (ResourceInfo)ftInfo, recalculate);
        CatalogBuilder helper = new CatalogBuilder(this.catalog);
        helper.updateFeatureType(ftInfo, featureTypeUpdate);
        this.catalog.validate((ResourceInfo)ftInfo, false).throwIfInvalid();
        this.catalog.save((ResourceInfo)ftInfo);
        this.catalog.getResourcePool().clear(ftInfo);
        Map parameters = ftInfo.getStore().getConnectionParameters();
        MetadataMap mdm = ftInfo.getMetadata();
        boolean bl = virtual = mdm != null && mdm.containsKey((Object)"JDBC_VIRTUAL_TABLE");
        if (!virtual && parameters.equals(parametersCheck)) {
            LOGGER.info("PUT FeatureType" + storeName + "," + featureTypeName + " updated metadata only");
        } else {
            LOGGER.info("PUT featureType" + storeName + "," + featureTypeName + " updated metadata and data access");
            this.catalog.getResourcePool().clear(ftInfo.getStore());
        }
    }

    @DeleteMapping(path={"{featureTypeName}"}, produces={"text/html", "application/json", "application/xml"})
    public void featureTypeDelete(@PathVariable String workspaceName, @PathVariable(required=false) String storeName, @PathVariable String featureTypeName, @RequestParam(name="recurse", defaultValue="false") Boolean recurse) {
        DataStoreInfo dsInfo = this.getExistingDataStore(workspaceName, storeName);
        FeatureTypeInfo ftInfo = this.catalog.getFeatureTypeByDataStore(dsInfo, featureTypeName);
        this.checkFeatureTypeExists(ftInfo, workspaceName, storeName, featureTypeName);
        List layers = this.catalog.getLayers((ResourceInfo)ftInfo);
        if (recurse.booleanValue()) {
            for (LayerInfo l : layers) {
                this.catalog.remove(l);
                LOGGER.info("DELETE layer " + l.getName());
            }
        } else if (!layers.isEmpty()) {
            throw new RestException("feature type referenced by layer(s)", HttpStatus.FORBIDDEN);
        }
        this.catalog.remove((ResourceInfo)ftInfo);
        LOGGER.info("DELETE feature type" + storeName + "," + featureTypeName);
    }

    @RequestMapping(value={"{featureTypeName}/reset"}, method={RequestMethod.POST, RequestMethod.PUT})
    public void reset(@PathVariable String workspaceName, @PathVariable(required=false) String storeName, @PathVariable String featureTypeName) {
        DataStoreInfo dsInfo = this.getExistingDataStore(workspaceName, storeName);
        FeatureTypeInfo ftInfo = this.catalog.getFeatureTypeByDataStore(dsInfo, featureTypeName);
        this.checkFeatureTypeExists(ftInfo, workspaceName, storeName, featureTypeName);
        this.catalog.getResourcePool().clear(ftInfo);
    }

    private void checkFeatureTypeExists(FeatureTypeInfo featureType, String workspaceName, String storeName, String featureTypeName) {
        if (featureType == null && storeName == null) {
            throw new ResourceNotFoundException(String.format("No such feature type: %s,%s", workspaceName, featureTypeName));
        }
        if (featureType == null) {
            throw new ResourceNotFoundException(String.format("No such feature type: %s,%s,%s", workspaceName, storeName, featureTypeName));
        }
    }

    private DataStoreInfo getExistingDataStore(String workspaceName, String storeName) {
        DataStoreInfo original = this.catalog.getDataStoreByName(workspaceName, storeName);
        if (original == null) {
            throw new ResourceNotFoundException("No such data store: " + workspaceName + "," + storeName);
        }
        return original;
    }

    SimpleFeatureType buildFeatureType(FeatureTypeInfo fti) {
        if (fti.getName() == null) {
            throw new RestException("Trying to create new feature type inside the store, but no feature type name was specified", HttpStatus.BAD_REQUEST);
        }
        if (fti.getAttributes() == null || fti.getAttributes().isEmpty()) {
            throw new RestException("Trying to create new feature type inside the store, but no attributes were specified", HttpStatus.BAD_REQUEST);
        }
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        if (fti.getNativeName() != null) {
            builder.setName(fti.getNativeName());
        } else {
            builder.setName(fti.getName());
        }
        if (fti.getNativeCRS() != null) {
            builder.setCRS(fti.getNativeCRS());
        } else if (fti.getCRS() != null) {
            builder.setCRS(fti.getCRS());
        } else if (fti.getSRS() != null) {
            builder.setSRS(fti.getSRS());
        }
        for (AttributeTypeInfo ati : fti.getAttributes()) {
            if (ati.getLength() != null && ati.getLength() > 0) {
                builder.length(ati.getLength().intValue());
            }
            builder.nillable(ati.isNillable());
            builder.add(ati.getName(), ati.getBinding());
        }
        return builder.buildFeatureType();
    }

    public boolean supports(MethodParameter methodParameter, Type targetType, Class<? extends HttpMessageConverter<?>> converterType) {
        return FeatureTypeInfo.class.isAssignableFrom(methodParameter.getParameterType());
    }

    public void configurePersister(XStreamPersister persister, final XStreamMessageConverter converter) {
        ServletRequestAttributes attrs = (ServletRequestAttributes)this.getNonNullRequestAttributes();
        String method = attrs.getRequest().getMethod();
        if ("GET".equalsIgnoreCase(method)) {
            persister.setHideFeatureTypeAttributes();
        }
        persister.setCallback(new XStreamPersister.Callback(){

            protected Class<FeatureTypeInfo> getObjectClass() {
                return FeatureTypeInfo.class;
            }

            protected CatalogInfo getCatalogObject() {
                Map uriTemplateVars = FeatureTypeController.this.getURITemplateVariables();
                String workspace = (String)uriTemplateVars.get("workspaceName");
                String featuretype = (String)uriTemplateVars.get("featureTypeName");
                String datastore = (String)uriTemplateVars.get("storeName");
                if (workspace == null || datastore == null || featuretype == null) {
                    return null;
                }
                DataStoreInfo ds = FeatureTypeController.this.catalog.getDataStoreByName(workspace, datastore);
                if (ds == null) {
                    return null;
                }
                return FeatureTypeController.this.catalog.getFeatureTypeByDataStore(ds, featuretype);
            }

            protected void postEncodeReference(Object obj, String ref, String prefix, HierarchicalStreamWriter writer, MarshallingContext context) {
                if (obj instanceof NamespaceInfo) {
                    NamespaceInfo ns = (NamespaceInfo)obj;
                    converter.encodeLink("/namespaces/" + converter.encode(ns.getPrefix()), writer);
                }
                if (obj instanceof DataStoreInfo) {
                    DataStoreInfo ds = (DataStoreInfo)obj;
                    converter.encodeLink("/workspaces/" + converter.encode(ds.getWorkspace().getName()) + "/datastores/" + converter.encode(ds.getName()), writer);
                }
            }

            protected void postEncodeFeatureType(FeatureTypeInfo ft, HierarchicalStreamWriter writer, MarshallingContext context) {
                try {
                    writer.startNode("attributes");
                    context.convertAnother((Object)ft.attributes());
                    writer.endNode();
                }
                catch (IOException e) {
                    throw new RuntimeException("Could not get native attributes", e);
                }
            }
        });
    }

    protected <T> ObjectWrapper createObjectWrapper(Class<T> clazz) {
        return new ObjectToMapWrapper<FeatureTypeInfo>(FeatureTypeInfo.class){

            protected void wrapInternal(Map<String, Object> properties, SimpleHash model, FeatureTypeInfo object) {
                try {
                    properties.put("boundingBox", object.boundingBox());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }
}

