/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest.catalog;

import java.io.IOException;
import org.geoserver.rest.catalog.FormatCollectionWrapper;
import org.geoserver.rest.converters.BaseMessageConverter;
import org.geotools.data.geojson.GeoJSONWriter;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.wfs.GML;
import org.opengis.feature.simple.SimpleFeatureType;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageNotWritableException;

public abstract class FeatureCollectionConverter<T>
extends BaseMessageConverter<T> {
    public FeatureCollectionConverter(MediaType ... supportedMediaTypes) {
        super(supportedMediaTypes);
    }

    protected boolean supports(Class<?> clazz) {
        return SimpleFeatureCollection.class.isAssignableFrom(clazz) || FormatCollectionWrapper.JSONCollectionWrapper.class.isAssignableFrom(clazz);
    }

    public boolean canRead(Class<?> clazz, MediaType mediaType) {
        return false;
    }

    protected void writeGeoJson(SimpleFeatureCollection features, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        try (GeoJSONWriter writer = new GeoJSONWriter(outputMessage.getBody());){
            boolean geometryless = ((SimpleFeatureType)features.getSchema()).getGeometryDescriptor() == null;
            writer.setEncodeFeatureCollectionCRS(!geometryless);
            writer.writeFeatureCollection(features);
        }
    }

    protected void writeGML(SimpleFeatureCollection features, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        GML gml = new GML(GML.Version.WFS1_0);
        gml.setNamespace("gf", ((SimpleFeatureType)features.getSchema()).getName().getNamespaceURI());
        gml.encode(outputMessage.getBody(), features);
    }
}

