/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest.catalog;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.resource.Paths;
import org.geoserver.platform.resource.Resource;
import org.geoserver.platform.resource.Resources;
import org.geoserver.rest.RestException;
import org.geoserver.rest.catalog.AbstractStoreUploadController;
import org.geoserver.rest.util.RESTUploadPathMapper;
import org.geotools.data.DataAccess;
import org.geotools.data.DataAccessFactory;
import org.geotools.data.DataStore;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.FeatureSource;
import org.geotools.data.FeatureStore;
import org.geotools.data.FileDataStoreFactorySpi;
import org.geotools.data.Transaction;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.simple.SimpleFeatureStore;
import org.geotools.feature.FeatureCollection;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.jdbc.JDBCDataStoreFactory;
import org.geotools.util.URLs;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.vfny.geoserver.util.DataStoreUtils;

@RestController
@ControllerAdvice
@RequestMapping(path={"/rest/workspaces/{workspaceName}/datastores/{storeName}/{method}.{format}"})
public class DataStoreFileController
extends AbstractStoreUploadController {
    private static final Pattern H2_FILE_PATTERN = Pattern.compile("(.*?)\\.(?:data.db)");
    protected static final HashMap<String, String> formatToDataStoreFactory = new HashMap();
    protected static final Map<String, Map<String, Serializable>> dataStoreFactoryToDefaultParams;

    @Autowired
    public DataStoreFileController(@Qualifier(value="catalog") Catalog catalog) {
        super(catalog);
    }

    public static DataAccessFactory lookupDataStoreFactory(String format) {
        String factoryClassName = formatToDataStoreFactory.get(format);
        if (factoryClassName != null) {
            try {
                Class<?> factoryClass = Class.forName(factoryClassName);
                return (DataAccessFactory)factoryClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new RestException("Datastore format unavailable: " + factoryClassName, HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        String extension = "." + format;
        for (DataAccessFactory dataAccessFactory : DataStoreUtils.getAvailableDataStoreFactories()) {
            if (!(dataAccessFactory instanceof FileDataStoreFactorySpi)) continue;
            FileDataStoreFactorySpi factory = (FileDataStoreFactorySpi)dataAccessFactory;
            for (String handledExtension : factory.getFileExtensions()) {
                if (!extension.equalsIgnoreCase(handledExtension)) continue;
                return factory;
            }
        }
        throw new RestException("Unsupported format: " + format, HttpStatus.BAD_REQUEST);
    }

    public static String lookupDataStoreFactoryFormat(String type) {
        for (DataAccessFactory factory : DataStoreUtils.getAvailableDataStoreFactories()) {
            if (factory == null || factory.getDisplayName() == null || !factory.getDisplayName().equals(type)) continue;
            for (Map.Entry<String, String> e : formatToDataStoreFactory.entrySet()) {
                if (!e.getValue().equals(factory.getClass().getCanonicalName())) continue;
                return e.getKey();
            }
            return factory.getDisplayName();
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    @GetMapping
    public ResponseEntity dataStoresGet(@PathVariable String workspaceName, @PathVariable String storeName) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PutMapping
    public void dataStorePut(@PathVariable String workspaceName, @PathVariable String storeName, @PathVariable AbstractStoreUploadController.UploadMethod method, @PathVariable String format, @RequestParam(name="configure", required=false) String configure, @RequestParam(name="target", required=false) String target, @RequestParam(name="update", required=false) String update, @RequestParam(name="charset", required=false) String characterset, @RequestParam(name="filename", required=false) String filename, HttpServletRequest request, HttpServletResponse response) throws IOException {
        boolean canRemoveFiles;
        Resource uploadedFile;
        List<Resource> files;
        block63: {
            DataAccess ds;
            DataAccess source;
            boolean createNewSource;
            NamespaceInfo namespace;
            DataStoreInfo info;
            CatalogBuilder builder;
            block61: {
                block62: {
                    response.setStatus(HttpStatus.ACCEPTED.value());
                    files = this.doFileUpload(method, workspaceName, storeName, filename, format, request);
                    uploadedFile = files.get(0);
                    DataAccessFactory factory = DataStoreFileController.lookupDataStoreFactory(format);
                    String sourceDataStoreFormat = format;
                    String targetDataStoreFormat = target;
                    if (targetDataStoreFormat == null) {
                        targetDataStoreFormat = sourceDataStoreFormat;
                    }
                    sourceDataStoreFormat = sourceDataStoreFormat.toLowerCase();
                    targetDataStoreFormat = targetDataStoreFormat.toLowerCase();
                    builder = new CatalogBuilder(this.catalog);
                    builder.setWorkspace(this.catalog.getWorkspaceByName(workspaceName));
                    info = this.catalog.getDataStoreByName(workspaceName, storeName);
                    namespace = this.catalog.getNamespaceByPrefix(workspaceName);
                    boolean add = false;
                    boolean save = false;
                    canRemoveFiles = false;
                    if (info == null) {
                        LOGGER.info("Auto-configuring datastore: " + storeName);
                        info = builder.buildDataStore(storeName);
                        add = true;
                        if (characterset != null && characterset.length() > 0) {
                            info.getConnectionParameters().put("charset", characterset);
                        }
                        DataAccessFactory targetFactory = factory;
                        if (!targetDataStoreFormat.equals(sourceDataStoreFormat)) {
                            targetFactory = DataStoreFileController.lookupDataStoreFactory(targetDataStoreFormat);
                            if (targetFactory == null) {
                                throw new RestException("Unable to create data store of type " + targetDataStoreFormat, HttpStatus.BAD_REQUEST);
                            }
                            this.autoCreateParameters(info, namespace, targetFactory);
                            canRemoveFiles = true;
                        } else {
                            this.updateParameters(info, namespace, targetFactory, uploadedFile);
                        }
                        info.setType(targetFactory.getDisplayName());
                    } else {
                        LOGGER.info("Using existing datastore: " + storeName);
                        targetDataStoreFormat = DataStoreFileController.lookupDataStoreFactoryFormat(info.getType());
                        if (targetDataStoreFormat == null) {
                            throw new RuntimeException("Unable to locate data store factory of type " + info.getType());
                        }
                        if (targetDataStoreFormat.equals(sourceDataStoreFormat)) {
                            save = true;
                            this.updateParameters(info, namespace, factory, uploadedFile);
                        } else {
                            canRemoveFiles = true;
                        }
                    }
                    builder.setStore((StoreInfo)info);
                    if (add) {
                        this.catalog.validate((StoreInfo)info, true).throwIfInvalid();
                        this.catalog.add((StoreInfo)info);
                    } else if (save) {
                        this.catalog.validate((StoreInfo)info, false).throwIfInvalid();
                        this.catalog.save((StoreInfo)info);
                    }
                    try {
                        HashMap<String, Serializable> params = new HashMap<String, Serializable>();
                        if (characterset != null && characterset.length() > 0) {
                            params.put("charset", (Serializable)((Object)characterset));
                        }
                        params.put("namespace", (Serializable)((Object)namespace.getURI()));
                        this.updateParameters(params, factory, uploadedFile);
                        createNewSource = !this.sameTypeAndUrl(params, info.getConnectionParameters());
                        source = createNewSource ? factory.createDataStore(params) : info.getDataStore(null);
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Unable to create source data store", e);
                    }
                    ds = info.getDataStore(null);
                    if (!targetDataStoreFormat.equals(sourceDataStoreFormat) && source instanceof DataStore && ds instanceof DataStore) {
                        DataStore sourceDataStore = (DataStore)source;
                        DataStore targetDataStore = (DataStore)ds;
                        for (String featureTypeName : sourceDataStore.getTypeNames()) {
                            try {
                                targetDataStore.getSchema(featureTypeName);
                            }
                            catch (Exception e) {
                                LOGGER.info(featureTypeName + " does not exist in data store " + storeName + ". Attempting to create it");
                                targetDataStore.createSchema((FeatureType)sourceDataStore.getSchema(featureTypeName));
                                sourceDataStore.getSchema(featureTypeName);
                            }
                            SimpleFeatureSource featureSource = targetDataStore.getFeatureSource(featureTypeName);
                            if (!(featureSource instanceof FeatureStore)) {
                                LOGGER.warning(featureTypeName + " is not writable, skipping");
                                continue;
                            }
                            try (DefaultTransaction tx = new DefaultTransaction();){
                                SimpleFeatureStore featureStore = (SimpleFeatureStore)featureSource;
                                featureStore.setTransaction((Transaction)tx);
                                if ("overwrite".equalsIgnoreCase(update)) {
                                    LOGGER.fine("Removing existing features from " + featureTypeName);
                                    featureStore.removeFeatures((Filter)Filter.INCLUDE);
                                }
                                LOGGER.fine("Adding features to " + featureTypeName);
                                SimpleFeatureCollection features = sourceDataStore.getFeatureSource(featureTypeName).getFeatures();
                                featureStore.addFeatures((FeatureCollection)features);
                                tx.commit();
                            }
                        }
                    }
                    if (!"none".equalsIgnoreCase(configure)) break block61;
                    response.setStatus(HttpStatus.CREATED.value());
                    if (!createNewSource) break block62;
                    source.dispose();
                }
                if (method.isInline() && canRemoveFiles) {
                    if (uploadedFile.getType() == Resource.Type.RESOURCE) {
                        if (!uploadedFile.parent().delete()) {
                            LOGGER.info("Unable to delete " + uploadedFile.path());
                        }
                    } else if (uploadedFile.getType() == Resource.Type.DIRECTORY) {
                        for (Resource file : files) {
                            if (file.getType() != Resource.Type.RESOURCE || file.delete()) continue;
                            LOGGER.info("Unable to delete " + file.path());
                        }
                    }
                }
                return;
            }
            try {
                HashMap<String, FeatureTypeInfo> featureTypesByNativeName = new HashMap<String, FeatureTypeInfo>();
                for (FeatureTypeInfo ftInfo : this.catalog.getFeatureTypesByDataStore(info)) {
                    featureTypesByNativeName.put(ftInfo.getNativeName(), ftInfo);
                }
                List featureTypeNames = source.getNames();
                for (int i = 0; i < featureTypeNames.size() && ("all".equalsIgnoreCase(configure) || i <= 0); ++i) {
                    FeatureSource fs = ds.getFeatureSource((Name)featureTypeNames.get(i));
                    FeatureTypeInfo ftinfo = (FeatureTypeInfo)featureTypesByNativeName.get(((Name)featureTypeNames.get(i)).getLocalPart());
                    if (ftinfo == null) {
                        ftinfo = builder.buildFeatureType(fs);
                        builder.lookupSRS(ftinfo, true);
                        builder.setupBounds((ResourceInfo)ftinfo);
                    }
                    ReferencedEnvelope bounds = fs.getBounds();
                    ftinfo.setNativeBoundingBox(bounds);
                    if (ftinfo.getId() == null) {
                        if (this.catalog.getFeatureTypeByName(namespace, ftinfo.getName()) != null) {
                            LOGGER.warning(String.format("Feature type %s already exists in namespace %s, attempting to rename", ftinfo.getName(), namespace.getPrefix()));
                            int x = 1;
                            String originalName = ftinfo.getName();
                            do {
                                ftinfo.setName(originalName + x);
                                ++x;
                            } while (this.catalog.getFeatureTypeByName(namespace, ftinfo.getName()) != null);
                        }
                        this.catalog.validate((ResourceInfo)ftinfo, true).throwIfInvalid();
                        this.catalog.add((ResourceInfo)ftinfo);
                        LayerInfo layer = builder.buildLayer(ftinfo);
                        boolean valid = true;
                        try {
                            if (!this.catalog.validate(layer, true).isValid()) {
                                valid = false;
                            }
                        }
                        catch (Exception e) {
                            valid = false;
                        }
                        layer.setEnabled(valid);
                        this.catalog.add(layer);
                        LOGGER.info("Added feature type " + ftinfo.getName());
                    } else {
                        LOGGER.info("Updated feature type " + ftinfo.getName());
                        this.catalog.validate((ResourceInfo)ftinfo, false).throwIfInvalid();
                        this.catalog.save((ResourceInfo)ftinfo);
                    }
                    response.setStatus(HttpStatus.CREATED.value());
                }
                if (!createNewSource) break block63;
            }
            catch (Exception e) {
                try {
                    throw new RuntimeException(e);
                }
                catch (Throwable throwable) {
                    if (createNewSource) {
                        source.dispose();
                    }
                    if (method.isInline() && canRemoveFiles) {
                        if (uploadedFile.getType() == Resource.Type.RESOURCE) {
                            if (!uploadedFile.parent().delete()) {
                                LOGGER.info("Unable to delete " + uploadedFile.path());
                            }
                        } else if (uploadedFile.getType() == Resource.Type.DIRECTORY) {
                            for (Resource file : files) {
                                if (file.getType() != Resource.Type.RESOURCE || file.delete()) continue;
                                LOGGER.info("Unable to delete " + file.path());
                            }
                        }
                    }
                    throw throwable;
                }
            }
            source.dispose();
        }
        if (method.isInline() && canRemoveFiles) {
            if (uploadedFile.getType() == Resource.Type.RESOURCE) {
                if (!uploadedFile.parent().delete()) {
                    LOGGER.info("Unable to delete " + uploadedFile.path());
                }
            } else if (uploadedFile.getType() == Resource.Type.DIRECTORY) {
                for (Resource file : files) {
                    if (file.getType() != Resource.Type.RESOURCE || file.delete()) continue;
                    LOGGER.info("Unable to delete " + file.path());
                }
            }
        }
    }

    protected List<Resource> doFileUpload(AbstractStoreUploadController.UploadMethod method, String workspaceName, String storeName, String filename, String format, HttpServletRequest request) throws IOException {
        boolean postRequest;
        Resource directory = null;
        boolean bl = postRequest = request != null && HttpMethod.POST.name().equalsIgnoreCase(request.getMethod());
        if (method.isInline()) {
            directory = method == AbstractStoreUploadController.UploadMethod.url ? this.createFinalRoot(null, null, postRequest) : this.createFinalRoot(workspaceName, storeName, postRequest);
        }
        return this.handleFileUpload(storeName, workspaceName, filename, method, format, directory, request);
    }

    private Resource createFinalRoot(String workspaceName, String storeName, boolean isPost) throws IOException {
        CoverageStoreInfo coverage;
        Resource directory = null;
        if (isPost && storeName != null && (coverage = this.catalog.getCoverageStoreByName(storeName)) != null && (workspaceName == null || coverage.getWorkspace().getName().equalsIgnoreCase(workspaceName))) {
            directory = Resources.fromPath((String)URLs.urlToFile((URL)new URL(coverage.getURL())).getPath(), (Resource)this.catalog.getResourceLoader().get(""));
        }
        if (directory == null) {
            directory = this.catalog.getResourceLoader().get(Paths.path((String[])new String[]{"data", workspaceName, storeName}));
        }
        StringBuilder root = new StringBuilder(directory.path());
        HashMap storeParams = new HashMap();
        List mappers = GeoServerExtensions.extensions(RESTUploadPathMapper.class);
        for (RESTUploadPathMapper mapper : mappers) {
            mapper.mapStorePath(root, workspaceName, storeName, storeParams);
        }
        directory = Resources.fromPath((String)root.toString());
        return directory;
    }

    @Override
    protected Resource findPrimaryFile(Resource directory, String format) {
        if ("shp".equalsIgnoreCase(format) || "h2".equalsIgnoreCase(format)) {
            return directory;
        }
        return super.findPrimaryFile(directory, format);
    }

    void updateParameters(DataStoreInfo info, NamespaceInfo namespace, DataAccessFactory factory, Resource uploadedFile) {
        Map connectionParameters = info.getConnectionParameters();
        this.updateParameters(connectionParameters, factory, uploadedFile);
        connectionParameters.put("namespace", namespace.getURI());
        if (!factory.canProcess(connectionParameters)) {
            throw new RestException("Unable to configure datastore, bad parameters.", HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    void updateParameters(Map<String, Serializable> connectionParameters, DataAccessFactory factory, Resource uploadedFile) {
        File f = Resources.find((Resource)uploadedFile);
        for (DataAccessFactory.Param p : factory.getParametersInfo()) {
            if (File.class == p.type || URL.class == p.type) {
                if ("directory".equals(p.key)) {
                    f = f.getParentFile();
                }
                Serializable converted = null;
                if (URI.class.equals((Object)p.type)) {
                    converted = f.toURI();
                } else if (URL.class.equals((Object)p.type)) {
                    converted = URLs.fileToUrl((File)f);
                }
                if (converted != null) {
                    connectionParameters.put(p.key, converted);
                    continue;
                }
                connectionParameters.put(p.key, f);
                continue;
            }
            if (!p.required) continue;
            try {
                p.lookUp(connectionParameters);
            }
            catch (Exception e) {
                connectionParameters.put(p.key, (Serializable)p.sample);
            }
        }
        if (factory.getDisplayName().equalsIgnoreCase("SpatiaLite")) {
            connectionParameters.put(JDBCDataStoreFactory.DATABASE.getName(), (Serializable)((Object)f.getAbsolutePath()));
        } else if (factory.getDisplayName().equalsIgnoreCase("H2")) {
            Matcher matcher;
            String databaseFile = f.getAbsolutePath();
            if (f.isDirectory()) {
                Optional found = Resources.list((Resource)uploadedFile, resource -> resource.name().endsWith("data.db")).stream().findFirst();
                if (!found.isPresent()) {
                    throw new RestException(String.format("H2 database file could not be found in directory '%s'.", f.getAbsolutePath()), HttpStatus.INTERNAL_SERVER_ERROR);
                }
                databaseFile = ((Resource)found.get()).file().getAbsolutePath();
            }
            if (!(matcher = H2_FILE_PATTERN.matcher(databaseFile)).matches()) {
                throw new RestException(String.format("Invalid H2 database file '%s'.", databaseFile), HttpStatus.INTERNAL_SERVER_ERROR);
            }
            connectionParameters.put(JDBCDataStoreFactory.DATABASE.getName(), (Serializable)((Object)matcher.group(1)));
        }
    }

    void autoCreateParameters(DataStoreInfo info, NamespaceInfo namespace, DataAccessFactory factory) {
        Map<String, Serializable> defaultParams = dataStoreFactoryToDefaultParams.get(factory.getClass().getCanonicalName());
        if (defaultParams == null) {
            throw new RuntimeException("Unable to auto create parameters for " + factory.getDisplayName());
        }
        HashMap<String, Serializable> params = new HashMap<String, Serializable>(defaultParams);
        String dataDirRoot = this.catalog.getResourceLoader().getBaseDirectory().getAbsolutePath();
        for (Map.Entry entry : params.entrySet()) {
            if (!(entry.getValue() instanceof String)) continue;
            String string = (String)entry.getValue();
            string = string.replace("@NAME@", info.getName()).replace("@DATA_DIR@", dataDirRoot);
            entry.setValue(string);
        }
        params.put("namespace", (Serializable)((Object)namespace.getURI()));
        info.getConnectionParameters().putAll(params);
    }

    private boolean sameTypeAndUrl(Map sourceParams, Map targetParams) {
        boolean sameType = sourceParams.get("dbtype") != null && targetParams.get("dbtype") != null && sourceParams.get("dbtype").equals(targetParams.get("dbtype"));
        boolean sameUrl = sourceParams.get("url") != null && targetParams.get("url") != null && sourceParams.get("url").equals(targetParams.get("url"));
        return sameType && sameUrl;
    }

    static {
        formatToDataStoreFactory.put("shp", "org.geotools.data.shapefile.ShapefileDataStoreFactory");
        formatToDataStoreFactory.put("properties", "org.geotools.data.property.PropertyDataStoreFactory");
        formatToDataStoreFactory.put("h2", "org.geotools.data.h2.H2DataStoreFactory");
        formatToDataStoreFactory.put("appschema", "org.geotools.data.complex.AppSchemaDataAccessFactory");
        formatToDataStoreFactory.put("gpkg", "org.geotools.geopkg.GeoPkgDataStoreFactory");
        formatToDataStoreFactory.put("mbtiles", "org.geotools.mbtiles.MBTilesDataStoreFactory");
        dataStoreFactoryToDefaultParams = new HashMap<String, Map<String, Serializable>>();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("database", "@DATA_DIR@/@NAME@");
        map.put("dbtype", "h2");
        dataStoreFactoryToDefaultParams.put("org.geotools.data.h2.H2DataStoreFactory", map);
    }
}

