/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest.catalog;

import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.config.util.XStreamPersister;
import org.geoserver.rest.ResourceNotFoundException;
import org.geoserver.rest.RestException;
import org.geoserver.rest.catalog.AbstractCatalogController;
import org.geoserver.rest.catalog.StringsList;
import org.geoserver.rest.converters.XStreamMessageConverter;
import org.geoserver.rest.wrapper.RestWrapper;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.grid.GridCoverageReader;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.MethodParameter;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

@RestController
@ControllerAdvice
@RequestMapping(path={"/rest/workspaces/{workspaceName}"})
public class CoverageController
extends AbstractCatalogController {
    private static final Logger LOGGER = Logging.getLogger(CoverageController.class);

    @Autowired
    public CoverageController(@Qualifier(value="catalog") Catalog catalog) {
        super(catalog);
    }

    @GetMapping(path={"coveragestores/{storeName}/coverages"}, produces={"text/xml", "application/xml", "application/json", "text/html"})
    public Object coveragesGet(@RequestParam(name="list", required=false) String list, @PathVariable String workspaceName, @PathVariable String storeName) {
        CoverageStoreInfo coverageStore = this.getExistingCoverageStore(workspaceName, storeName);
        if (list != null && list.equalsIgnoreCase("all")) {
            List<String> coverages = this.getStoreCoverages(coverageStore);
            return new StringsList(coverages, "coverageName");
        }
        List coverages = this.catalog.getCoveragesByCoverageStore(coverageStore);
        return this.wrapList(coverages, CoverageInfo.class);
    }

    @GetMapping(path={"coverages"}, produces={"text/xml", "application/xml", "application/json", "text/html", "text/json"})
    public Object coveragesGet(@RequestParam(name="list", required=false) String list, @PathVariable String workspaceName) {
        NamespaceInfo nameSpace = this.catalog.getNamespaceByPrefix(workspaceName);
        if (nameSpace == null) {
            throw new ResourceNotFoundException(String.format("Name space not found for workspace '%s'.", workspaceName));
        }
        if (list != null && list.equalsIgnoreCase("all")) {
            List<String> coverages = this.catalog.getCoverageStores().stream().flatMap(store -> this.getStoreCoverages((CoverageStoreInfo)store).stream()).collect(Collectors.toList());
            return new StringsList(coverages, "coverageName");
        }
        List coverages = this.catalog.getCoveragesByNamespace(nameSpace);
        return this.wrapList(coverages, CoverageInfo.class);
    }

    @GetMapping(path={"coveragestores/{storeName}/coverages/{coverageName}"}, produces={"text/xml", "application/xml", "application/json", "text/html", "text/json"})
    public RestWrapper<CoverageInfo> coverageGet(@PathVariable String workspaceName, @PathVariable String storeName, @PathVariable String coverageName) {
        CoverageStoreInfo coverageStore = this.getExistingCoverageStore(workspaceName, storeName);
        List coverages = this.catalog.getCoveragesByCoverageStore(coverageStore);
        Optional<CoverageInfo> optCoverage = coverages.stream().filter(ci -> coverageName.equals(ci.getName())).findFirst();
        if (!optCoverage.isPresent()) {
            throw new ResourceNotFoundException(String.format("No such coverage: %s,%s,%s", workspaceName, storeName, coverageName));
        }
        CoverageInfo coverage = optCoverage.get();
        this.checkCoverageExists(coverage, workspaceName, coverageName);
        return this.wrapObject(coverage, CoverageInfo.class);
    }

    @GetMapping(path={"coverages/{coverageName}"}, produces={"text/xml", "application/xml", "application/json", "text/html", "text/json"})
    public RestWrapper<CoverageInfo> coverageGet(@PathVariable String workspaceName, @PathVariable String coverageName) {
        NamespaceInfo nameSpace = this.catalog.getNamespaceByPrefix(workspaceName);
        if (nameSpace == null) {
            throw new ResourceNotFoundException(String.format("Name space not found for workspace '%s'.", workspaceName));
        }
        CoverageInfo coverage = this.catalog.getCoverageByName(nameSpace, coverageName);
        this.checkCoverageExists(coverage, workspaceName, coverageName);
        return this.wrapObject(coverage, CoverageInfo.class);
    }

    @PostMapping(path={"coverages", "coveragestores/{storeName}/coverages"}, consumes={"text/xml", "application/xml", "application/json"})
    public ResponseEntity<String> coveragePost(@RequestBody CoverageInfo coverage, @PathVariable String workspaceName, @PathVariable(required=false) String storeName, UriComponentsBuilder builder) throws Exception {
        String coverageName = this.handleObjectPost(coverage, workspaceName, storeName);
        UriComponents uriComponents = storeName == null ? builder.path("/workspaces/{workspaceName}/coverages/{coverageName}").buildAndExpand(new Object[]{workspaceName, storeName, coverageName}) : builder.path("/workspaces/{workspaceName}/coveragestores/{storeName}/coverages/{coverageName}").buildAndExpand(new Object[]{workspaceName, storeName, coverageName});
        HttpHeaders headers = new HttpHeaders();
        headers.setLocation(uriComponents.toUri());
        headers.setContentType(MediaType.TEXT_PLAIN);
        return new ResponseEntity((Object)coverageName, (MultiValueMap)headers, HttpStatus.CREATED);
    }

    @PutMapping(path={"coveragestores/{storeName}/coverages/{coverageName}"}, consumes={"text/xml", "application/xml", "application/json"})
    public void coveragePut(@RequestBody CoverageInfo coverage, @PathVariable String workspaceName, @PathVariable String storeName, @PathVariable String coverageName, @RequestParam(required=false) String calculate) throws Exception {
        CoverageStoreInfo cs = this.catalog.getCoverageStoreByName(workspaceName, storeName);
        CoverageInfo original = this.catalog.getCoverageByCoverageStore(cs, coverageName);
        this.checkCoverageExists(original, workspaceName, coverageName);
        this.calculateOptionalFields((ResourceInfo)coverage, (ResourceInfo)original, calculate);
        new CatalogBuilder(this.catalog).updateCoverage(original, coverage);
        this.catalog.validate((ResourceInfo)original, false).throwIfInvalid();
        this.catalog.save((ResourceInfo)original);
        this.catalog.getResourcePool().clear(original.getStore());
        LOGGER.info("PUT coverage " + storeName + "," + coverage);
    }

    @DeleteMapping(path={"coveragestores/{storeName}/coverages/{coverageName}"})
    protected void coverageDelete(@PathVariable String workspaceName, @PathVariable String storeName, @PathVariable String coverageName, @RequestParam(name="recurse", defaultValue="false") boolean recurse) {
        CoverageStoreInfo ds = this.catalog.getCoverageStoreByName(workspaceName, storeName);
        CoverageInfo c = this.catalog.getCoverageByCoverageStore(ds, coverageName);
        if (c == null) {
            throw new RestException(String.format("Coverage '%s' not found.", coverageName), HttpStatus.NOT_FOUND);
        }
        List layers = this.catalog.getLayers((ResourceInfo)c);
        if (recurse) {
            for (LayerInfo l : layers) {
                this.catalog.remove(l);
                LOGGER.info("DELETE layer " + l.getName());
            }
        } else if (!layers.isEmpty()) {
            throw new RestException("coverage referenced by layer(s)", HttpStatus.FORBIDDEN);
        }
        this.catalog.remove((ResourceInfo)c);
        this.catalog.getResourcePool().clear(c.getStore());
        LOGGER.info("DELETE coverage " + storeName + "," + coverageName);
    }

    @RequestMapping(value={"coveragestores/{storeName}/coverages/{coverageName}/reset"}, method={RequestMethod.POST, RequestMethod.PUT})
    public void reset(@PathVariable String workspaceName, @PathVariable String storeName, @PathVariable String coverageName) {
        CoverageStoreInfo cs = this.catalog.getCoverageStoreByName(workspaceName, storeName);
        CoverageInfo original = this.catalog.getCoverageByCoverageStore(cs, coverageName);
        this.checkCoverageExists(original, workspaceName, coverageName);
        this.catalog.getResourcePool().clear(original);
    }

    private List<String> getStoreCoverages(CoverageStoreInfo coverageStore) {
        try {
            GridCoverageReader reader = coverageStore.getGridCoverageReader(null, null);
            return Arrays.stream(reader.getGridCoverageNames()).collect(Collectors.toList());
        }
        catch (Exception exception) {
            throw new RuntimeException("Error getting coverages from coverage reader.", exception);
        }
    }

    private void checkCoverageExists(CoverageInfo coverage, String workspaceName, String coverageName) {
        if (coverage == null) {
            throw new ResourceNotFoundException(String.format("No such coverage: %s,%s", workspaceName, coverageName));
        }
    }

    private CoverageStoreInfo getExistingCoverageStore(String workspaceName, String storeName) {
        CoverageStoreInfo original = this.catalog.getCoverageStoreByName(workspaceName, storeName);
        if (original == null) {
            throw new ResourceNotFoundException("No such coverage store: " + workspaceName + "," + storeName);
        }
        return original;
    }

    private String handleObjectPost(CoverageInfo coverage, String workspace, String coverageStoreName) throws Exception {
        if (coverage.getStore() == null) {
            CoverageStoreInfo ds = this.catalog.getCoverageStoreByName(workspace, coverageStoreName);
            coverage.setStore((StoreInfo)ds);
        }
        boolean isNew = this.isNewCoverage(coverage);
        String nativeCoverageName = coverage.getNativeCoverageName();
        if (nativeCoverageName == null) {
            nativeCoverageName = coverage.getNativeName();
        }
        CatalogBuilder builder = new CatalogBuilder(this.catalog);
        CoverageStoreInfo store = coverage.getStore();
        builder.setStore((StoreInfo)store);
        if (!isNew) {
            builder.initCoverage(coverage, nativeCoverageName);
        } else {
            String specifiedName = coverage.getName();
            coverage = builder.buildCoverageByName(nativeCoverageName, specifiedName);
        }
        NamespaceInfo ns = coverage.getNamespace();
        if (ns != null && !ns.getPrefix().equals(workspace)) {
            LOGGER.warning("Namespace: " + ns.getPrefix() + " does not match workspace: " + workspace + ", overriding.");
            ns = null;
        }
        if (ns == null) {
            ns = this.catalog.getNamespaceByPrefix(workspace);
            coverage.setNamespace(ns);
        }
        coverage.setEnabled(true);
        this.catalog.validate((ResourceInfo)coverage, true).throwIfInvalid();
        this.catalog.add((ResourceInfo)coverage);
        this.catalog.add(builder.buildLayer(coverage));
        LOGGER.info("POST coverage " + coverageStoreName + "," + coverage.getName());
        return coverage.getName();
    }

    private boolean isNewCoverage(CoverageInfo coverage) {
        return coverage.getName() != null && coverage.isAdvertised() && !coverage.isEnabled() && coverage.getAlias() == null && coverage.getCRS() == null && coverage.getDefaultInterpolationMethod() == null && coverage.getDescription() == null && coverage.getDimensions() == null && coverage.getGrid() == null && coverage.getInterpolationMethods() == null && coverage.getKeywords() == null && coverage.getLatLonBoundingBox() == null && coverage.getMetadata() == null && coverage.getNativeBoundingBox() == null && coverage.getNativeCRS() == null && coverage.getNativeFormat() == null && coverage.getProjectionPolicy() == null && coverage.getSRS() == null && coverage.getResponseSRS() == null && coverage.getRequestSRS() == null;
    }

    public boolean supports(MethodParameter methodParameter, Type targetType, Class<? extends HttpMessageConverter<?>> converterType) {
        return CoverageInfo.class.isAssignableFrom(methodParameter.getParameterType());
    }

    public void configurePersister(XStreamPersister persister, final XStreamMessageConverter converter) {
        persister.setCallback(new XStreamPersister.Callback(){

            protected Class<CoverageInfo> getObjectClass() {
                return CoverageInfo.class;
            }

            protected CatalogInfo getCatalogObject() {
                Map uriTemplateVars = CoverageController.this.getURITemplateVariables();
                String workspace = (String)uriTemplateVars.get("workspaceName");
                String coveragestore = (String)uriTemplateVars.get("storeName");
                String coverage = (String)uriTemplateVars.get("coverageName");
                if (workspace == null || coveragestore == null || coverage == null) {
                    return null;
                }
                CoverageStoreInfo cs = CoverageController.this.catalog.getCoverageStoreByName(workspace, coveragestore);
                if (cs == null) {
                    return null;
                }
                return CoverageController.this.catalog.getCoverageByCoverageStore(cs, coverage);
            }

            protected void postEncodeReference(Object obj, String ref, String prefix, HierarchicalStreamWriter writer, MarshallingContext context) {
                if (obj instanceof NamespaceInfo) {
                    NamespaceInfo ns = (NamespaceInfo)obj;
                    converter.encodeLink("/namespaces/" + converter.encode(ns.getPrefix()), writer);
                }
                if (obj instanceof CoverageStoreInfo) {
                    CoverageStoreInfo cs = (CoverageStoreInfo)obj;
                    converter.encodeLink("/workspaces/" + converter.encode(cs.getWorkspace().getName()) + "/coveragestores/" + converter.encode(cs.getName()), writer);
                }
            }
        });
    }
}

