/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest.catalog;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.FilenameUtils;
import org.geoserver.catalog.Catalog;
import org.geoserver.platform.resource.Resource;
import org.geoserver.platform.resource.Resources;
import org.geoserver.rest.RestException;
import org.geoserver.rest.catalog.AbstractCatalogController;
import org.geoserver.rest.util.RESTUtils;
import org.geoserver.util.Filter;
import org.geotools.util.logging.Logging;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;

public abstract class AbstractStoreUploadController
extends AbstractCatalogController {
    static final Logger LOGGER = Logging.getLogger(AbstractStoreUploadController.class);

    public AbstractStoreUploadController(Catalog catalog) {
        super(catalog);
    }

    protected List<Resource> handleFileUpload(String store, String workspace, String filename, UploadMethod method, String format, Resource directory, HttpServletRequest request) {
        Resource uploadedFile;
        boolean external;
        ArrayList<Resource> files;
        block16: {
            files = new ArrayList<Resource>();
            external = false;
            try {
                if (method == UploadMethod.file) {
                    boolean cleanPreviousContents = HttpMethod.PUT.name().equals(request.getMethod());
                    if (filename == null) {
                        filename = this.buildUploadedFilename(store, format);
                    }
                    uploadedFile = RESTUtils.handleBinUpload((String)filename, (Resource)directory, (boolean)cleanPreviousContents, (HttpServletRequest)request, (String)workspace);
                    break block16;
                }
                if (method == UploadMethod.url) {
                    uploadedFile = RESTUtils.handleURLUpload((String)this.buildUploadedFilename(store, format), (String)workspace, (Resource)directory, (HttpServletRequest)request);
                    break block16;
                }
                if (method == UploadMethod.external) {
                    uploadedFile = RESTUtils.handleEXTERNALUpload((HttpServletRequest)request);
                    external = true;
                    break block16;
                }
                throw new RestException("Unrecognized file upload method: " + (Object)((Object)method), HttpStatus.BAD_REQUEST);
            }
            catch (Throwable t) {
                if (t instanceof RestException) {
                    throw (RestException)t;
                }
                throw new RestException("Error while storing uploaded file:", HttpStatus.INTERNAL_SERVER_ERROR, t);
            }
        }
        if (RESTUtils.isZipMediaType((HttpServletRequest)request)) {
            if (!uploadedFile.name().endsWith(".zip")) {
                Resource newUploadedFile = uploadedFile.parent().get(FilenameUtils.getBaseName((String)uploadedFile.path()) + ".zip");
                String oldFileName = uploadedFile.name();
                if (!uploadedFile.renameTo(newUploadedFile)) {
                    String errorMessage = "Error renaming zip file from " + oldFileName + " -> " + newUploadedFile.name();
                    throw new RestException(errorMessage, HttpStatus.INTERNAL_SERVER_ERROR);
                }
                uploadedFile = newUploadedFile;
            }
            try {
                RESTUtils.unzipFile((Resource)uploadedFile, (Resource)directory, (String)workspace, (String)store, files, (boolean)external);
                Resource primaryFile = this.findPrimaryFile(directory, format);
                if (primaryFile == null) {
                    throw new RestException("Could not find appropriate " + format + " file in archive", HttpStatus.BAD_REQUEST);
                }
                uploadedFile = primaryFile;
            }
            catch (RestException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RestException("Error occured unzipping file", HttpStatus.INTERNAL_SERVER_ERROR, (Throwable)e);
            }
        }
        if (files.isEmpty() && uploadedFile != null) {
            files.clear();
            files.add(uploadedFile);
        } else {
            files.add(0, uploadedFile);
        }
        return files;
    }

    private String buildUploadedFilename(String store, String format) {
        if ("h2".equalsIgnoreCase(format)) {
            return store + ".data.db";
        }
        return store + "." + format;
    }

    protected Resource findPrimaryFile(Resource directory, String format) {
        Iterator iterator = Resources.list((Resource)directory, (Filter)new Resources.ExtensionFilter(new String[]{format.toUpperCase()}), (boolean)true).iterator();
        if (iterator.hasNext()) {
            Resource f = (Resource)iterator.next();
            return f;
        }
        return null;
    }

    protected static enum UploadMethod {
        file(true),
        external(false),
        url(true),
        remote(false);

        boolean inline;

        private UploadMethod(boolean inline) {
            this.inline = inline;
        }

        public boolean isInline() {
            return this.inline;
        }
    }
}

