/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.process.raster;

import java.util.List;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.process.ProcessException;
import org.geotools.process.factory.DescribeParameter;
import org.geotools.process.factory.DescribeProcess;
import org.geotools.process.factory.DescribeResult;
import org.geotools.process.raster.CoverageUtilities;
import org.geotools.process.raster.MarchingSquaresVectorizer;
import org.geotools.process.raster.RasterProcess;
import org.geotools.util.Range;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.util.ProgressListener;

@DescribeProcess(title="Footprint Extraction", description="Extract footprint from a raster")
public class FootprintExtractionProcess
implements RasterProcess {
    @DescribeResult(name="result", description="The compute footprint geometry")
    public SimpleFeatureCollection execute(@DescribeParameter(name="data", description="Source raster") GridCoverage2D coverage, @DescribeParameter(name="exclusionRanges", description="the ranges of luminance values to be excluded by the computation.", min=0) List<Range<Integer>> exclusionRanges, @DescribeParameter(name="thresholdArea", description="Indicates the minimum area of a polygon to be included in the final result", min=0) Double thresholdArea, @DescribeParameter(name="computeSimplifiedFootprint", description="Indicates whether the simplified footprint should be computed", min=0) Boolean computeSimplifiedFootprint, @DescribeParameter(name="simplifierFactor", description="Indicates the simplifier factor to be applied when computing the simplified footprint", min=0) Double simplifierFactor, @DescribeParameter(name="removeCollinear", description="Indicates whether remove collinear point should be applied", min=0) Boolean removeCollinear, @DescribeParameter(name="forceValid", description="Indicates whether polygon should be forced to be valid, also removing holes", min=0) Boolean forceValid, @DescribeParameter(name="loadingType", description="Indicates which type of imageLoading should be performed (DEFERRED vs IMMEDIATE)", min=0) MarchingSquaresVectorizer.ImageLoadingType imageLoadingType, ProgressListener progressListener) throws ProcessException {
        if (coverage == null) {
            throw new ProcessException("Invalid input, source grid coverage should be not null");
        }
        if (exclusionRanges == null) {
            exclusionRanges = MarchingSquaresVectorizer.DEFAULT_RANGES;
        }
        if (computeSimplifiedFootprint == null) {
            computeSimplifiedFootprint = false;
        }
        if (simplifierFactor == null) {
            simplifierFactor = 2.0;
        }
        if (forceValid == null) {
            forceValid = true;
        }
        if (removeCollinear == null) {
            removeCollinear = true;
        }
        if (imageLoadingType == null) {
            imageLoadingType = MarchingSquaresVectorizer.ImageLoadingType.getDefault();
        }
        if (thresholdArea == null) {
            thresholdArea = 5.0;
        }
        MarchingSquaresVectorizer vectorizer = new MarchingSquaresVectorizer(coverage, null, thresholdArea, simplifierFactor, imageLoadingType, exclusionRanges);
        vectorizer.setComputeSimplifiedFootprint(computeSimplifiedFootprint);
        vectorizer.setForceValid(forceValid);
        vectorizer.setRemoveCollinear(removeCollinear);
        try {
            vectorizer.process();
            Geometry geometry = vectorizer.getFootprint();
            SimpleFeatureType featureType = CoverageUtilities.createFeatureType(coverage, Geometry.class);
            SimpleFeatureBuilder builder = new SimpleFeatureBuilder(featureType);
            int i = 0;
            ListFeatureCollection featureCollection = new ListFeatureCollection(featureType);
            builder.set("the_geom", (Object)geometry);
            featureCollection.add(builder.buildFeature(String.valueOf(i++)));
            if (computeSimplifiedFootprint.booleanValue()) {
                builder.set("the_geom", (Object)vectorizer.getSimplifiedFootprint());
                featureCollection.add(builder.buildFeature(String.valueOf(i++)));
            }
            ListFeatureCollection listFeatureCollection = featureCollection;
            return listFeatureCollection;
        }
        catch (Exception e) {
            throw new ProcessException("Exception occurred while computing the footprint", e);
        }
        finally {
            vectorizer.dispose();
        }
    }
}

