/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.configurers;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import javax.servlet.Filter;
import org.springframework.context.ApplicationContext;
import org.springframework.http.HttpMethod;
import org.springframework.security.config.annotation.web.AbstractRequestMatcherRegistry;
import org.springframework.security.config.annotation.web.HttpSecurityBuilder;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.ExceptionHandlingConfigurer;
import org.springframework.security.config.annotation.web.configurers.LogoutConfigurer;
import org.springframework.security.config.annotation.web.configurers.SessionManagementConfigurer;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.security.web.access.AccessDeniedHandlerImpl;
import org.springframework.security.web.access.DelegatingAccessDeniedHandler;
import org.springframework.security.web.authentication.logout.LogoutHandler;
import org.springframework.security.web.authentication.session.SessionAuthenticationStrategy;
import org.springframework.security.web.csrf.CsrfAuthenticationStrategy;
import org.springframework.security.web.csrf.CsrfFilter;
import org.springframework.security.web.csrf.CsrfLogoutHandler;
import org.springframework.security.web.csrf.CsrfTokenRepository;
import org.springframework.security.web.csrf.HttpSessionCsrfTokenRepository;
import org.springframework.security.web.csrf.LazyCsrfTokenRepository;
import org.springframework.security.web.csrf.MissingCsrfTokenException;
import org.springframework.security.web.servlet.util.matcher.MvcRequestMatcher;
import org.springframework.security.web.session.InvalidSessionAccessDeniedHandler;
import org.springframework.security.web.session.InvalidSessionStrategy;
import org.springframework.security.web.util.matcher.AndRequestMatcher;
import org.springframework.security.web.util.matcher.NegatedRequestMatcher;
import org.springframework.security.web.util.matcher.OrRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;

public final class CsrfConfigurer<H extends HttpSecurityBuilder<H>>
extends AbstractHttpConfigurer<CsrfConfigurer<H>, H> {
    private CsrfTokenRepository csrfTokenRepository = new LazyCsrfTokenRepository((CsrfTokenRepository)new HttpSessionCsrfTokenRepository());
    private RequestMatcher requireCsrfProtectionMatcher = CsrfFilter.DEFAULT_CSRF_MATCHER;
    private List<RequestMatcher> ignoredCsrfProtectionMatchers = new ArrayList<RequestMatcher>();
    private final ApplicationContext context;

    public CsrfConfigurer(ApplicationContext context) {
        this.context = context;
    }

    public CsrfConfigurer<H> csrfTokenRepository(CsrfTokenRepository csrfTokenRepository) {
        Assert.notNull((Object)csrfTokenRepository, (String)"csrfTokenRepository cannot be null");
        this.csrfTokenRepository = csrfTokenRepository;
        return this;
    }

    public CsrfConfigurer<H> requireCsrfProtectionMatcher(RequestMatcher requireCsrfProtectionMatcher) {
        Assert.notNull((Object)requireCsrfProtectionMatcher, (String)"requireCsrfProtectionMatcher cannot be null");
        this.requireCsrfProtectionMatcher = requireCsrfProtectionMatcher;
        return this;
    }

    public CsrfConfigurer<H> ignoringAntMatchers(String ... antPatterns) {
        return ((IgnoreCsrfProtectionRegistry)new IgnoreCsrfProtectionRegistry(this.context).antMatchers(antPatterns)).and();
    }

    public CsrfConfigurer<H> ignoringRequestMatchers(RequestMatcher ... requestMatchers) {
        return ((IgnoreCsrfProtectionRegistry)new IgnoreCsrfProtectionRegistry(this.context).requestMatchers(requestMatchers)).and();
    }

    @Override
    public void configure(H http) throws Exception {
        SessionManagementConfigurer sessionConfigurer;
        LogoutConfigurer logoutConfigurer;
        AccessDeniedHandler accessDeniedHandler;
        CsrfFilter filter = new CsrfFilter(this.csrfTokenRepository);
        RequestMatcher requireCsrfProtectionMatcher = this.getRequireCsrfProtectionMatcher();
        if (requireCsrfProtectionMatcher != null) {
            filter.setRequireCsrfProtectionMatcher(requireCsrfProtectionMatcher);
        }
        if ((accessDeniedHandler = this.createAccessDeniedHandler(http)) != null) {
            filter.setAccessDeniedHandler(accessDeniedHandler);
        }
        if ((logoutConfigurer = http.getConfigurer(LogoutConfigurer.class)) != null) {
            logoutConfigurer.addLogoutHandler((LogoutHandler)new CsrfLogoutHandler(this.csrfTokenRepository));
        }
        if ((sessionConfigurer = http.getConfigurer(SessionManagementConfigurer.class)) != null) {
            sessionConfigurer.addSessionAuthenticationStrategy((SessionAuthenticationStrategy)new CsrfAuthenticationStrategy(this.csrfTokenRepository));
        }
        filter = this.postProcess(filter);
        http.addFilter((Filter)filter);
    }

    private RequestMatcher getRequireCsrfProtectionMatcher() {
        if (this.ignoredCsrfProtectionMatchers.isEmpty()) {
            return this.requireCsrfProtectionMatcher;
        }
        return new AndRequestMatcher(new RequestMatcher[]{this.requireCsrfProtectionMatcher, new NegatedRequestMatcher((RequestMatcher)new OrRequestMatcher(this.ignoredCsrfProtectionMatchers))});
    }

    private AccessDeniedHandler getDefaultAccessDeniedHandler(H http) {
        ExceptionHandlingConfigurer exceptionConfig = http.getConfigurer(ExceptionHandlingConfigurer.class);
        AccessDeniedHandler handler = null;
        if (exceptionConfig != null) {
            handler = exceptionConfig.getAccessDeniedHandler();
        }
        if (handler == null) {
            handler = new AccessDeniedHandlerImpl();
        }
        return handler;
    }

    private InvalidSessionStrategy getInvalidSessionStrategy(H http) {
        SessionManagementConfigurer sessionManagement = http.getConfigurer(SessionManagementConfigurer.class);
        if (sessionManagement == null) {
            return null;
        }
        return sessionManagement.getInvalidSessionStrategy();
    }

    private AccessDeniedHandler createAccessDeniedHandler(H http) {
        InvalidSessionStrategy invalidSessionStrategy = this.getInvalidSessionStrategy(http);
        AccessDeniedHandler defaultAccessDeniedHandler = this.getDefaultAccessDeniedHandler(http);
        if (invalidSessionStrategy == null) {
            return defaultAccessDeniedHandler;
        }
        InvalidSessionAccessDeniedHandler invalidSessionDeniedHandler = new InvalidSessionAccessDeniedHandler(invalidSessionStrategy);
        LinkedHashMap<Class<MissingCsrfTokenException>, InvalidSessionAccessDeniedHandler> handlers = new LinkedHashMap<Class<MissingCsrfTokenException>, InvalidSessionAccessDeniedHandler>();
        handlers.put(MissingCsrfTokenException.class, invalidSessionDeniedHandler);
        return new DelegatingAccessDeniedHandler(handlers, defaultAccessDeniedHandler);
    }

    private final class MvcMatchersIgnoreCsrfProtectionRegistry
    extends IgnoreCsrfProtectionRegistry {
        private final List<MvcRequestMatcher> mvcMatchers;

        private MvcMatchersIgnoreCsrfProtectionRegistry(ApplicationContext context, List<MvcRequestMatcher> mvcMatchers) {
            super(context);
            this.mvcMatchers = mvcMatchers;
        }

        public IgnoreCsrfProtectionRegistry servletPath(String servletPath) {
            for (MvcRequestMatcher matcher : this.mvcMatchers) {
                matcher.setServletPath(servletPath);
            }
            return this;
        }
    }

    private class IgnoreCsrfProtectionRegistry
    extends AbstractRequestMatcherRegistry<IgnoreCsrfProtectionRegistry> {
        private IgnoreCsrfProtectionRegistry(ApplicationContext context) {
            this.setApplicationContext(context);
        }

        @Override
        public MvcMatchersIgnoreCsrfProtectionRegistry mvcMatchers(HttpMethod method, String ... mvcPatterns) {
            List<MvcRequestMatcher> mvcMatchers = this.createMvcMatchers(method, mvcPatterns);
            CsrfConfigurer.this.ignoredCsrfProtectionMatchers.addAll(mvcMatchers);
            return new MvcMatchersIgnoreCsrfProtectionRegistry(this.getApplicationContext(), mvcMatchers);
        }

        @Override
        public MvcMatchersIgnoreCsrfProtectionRegistry mvcMatchers(String ... mvcPatterns) {
            return this.mvcMatchers((HttpMethod)null, mvcPatterns);
        }

        public CsrfConfigurer<H> and() {
            return CsrfConfigurer.this;
        }

        @Override
        protected IgnoreCsrfProtectionRegistry chainRequestMatchers(List<RequestMatcher> requestMatchers) {
            CsrfConfigurer.this.ignoredCsrfProtectionMatchers.addAll(requestMatchers);
            return this;
        }
    }
}

