/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.property;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.geotools.data.DataUtilities;
import org.geotools.data.DefaultServiceInfo;
import org.geotools.data.Query;
import org.geotools.data.ServiceInfo;
import org.geotools.data.property.PropertyFeatureSource;
import org.geotools.data.property.PropertyFeatureStore;
import org.geotools.data.store.ContentDataStore;
import org.geotools.data.store.ContentEntry;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureTypes;
import org.geotools.feature.NameImpl;
import org.geotools.feature.type.FeatureTypeFactoryImpl;
import org.locationtech.jts.geom.GeometryFactory;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.Name;

public class PropertyDataStore
extends ContentDataStore {
    protected File dir;

    public PropertyDataStore(File dir) {
        this(dir, null);
    }

    public PropertyDataStore(File dir, String namespaceURI) {
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException(dir + " is not a directory");
        }
        if (namespaceURI == null) {
            namespaceURI = dir.getName();
        }
        this.dir = dir;
        this.setNamespaceURI(namespaceURI);
        this.setFilterFactory(CommonFactoryFinder.getFilterFactory(null));
        this.setGeometryFactory(new GeometryFactory());
        this.setFeatureTypeFactory(new FeatureTypeFactoryImpl());
        this.setFeatureFactory(CommonFactoryFinder.getFeatureFactory(null));
    }

    @Override
    public void createSchema(SimpleFeatureType featureType) throws IOException {
        String typeName = featureType.getTypeName();
        File file = new File(this.dir, typeName + ".properties");
        if (file.exists()) {
            throw new FileNotFoundException("Unable to create a new property file: file exists " + file);
        }
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
            writer.write("_=");
            writer.write(DataUtilities.encodeType(featureType));
            writer.flush();
        }
    }

    @Override
    public ServiceInfo getInfo() {
        DefaultServiceInfo info = new DefaultServiceInfo();
        info.setDescription("Features from Directory " + this.dir);
        info.setSchema(FeatureTypes.DEFAULT_NAMESPACE);
        info.setSource(this.dir.toURI());
        try {
            info.setPublisher(new URI(System.getProperty("user.name")));
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return info;
    }

    @Override
    public void setNamespaceURI(String namespaceURI) {
        this.namespaceURI = namespaceURI;
    }

    @Override
    protected List<Name> createTypeNames() throws IOException {
        String[] list = this.dir.list((dir, name) -> name.endsWith(".properties"));
        ArrayList<Name> typeNames = new ArrayList<Name>();
        if (list != null) {
            for (String s : list) {
                String typeName = s.substring(0, s.lastIndexOf(46));
                typeNames.add(new NameImpl(this.namespaceURI, typeName));
            }
        }
        return typeNames;
    }

    @Override
    public List<Name> getNames() throws IOException {
        String[] typeNames = this.getTypeNames();
        ArrayList<Name> names = new ArrayList<Name>(typeNames.length);
        for (String typeName : typeNames) {
            names.add(new NameImpl(this.namespaceURI, typeName));
        }
        return names;
    }

    @Override
    protected ContentFeatureSource createFeatureSource(ContentEntry entry) throws IOException {
        File file = new File(this.dir, entry.getTypeName() + ".properties");
        if (!file.exists()) {
            throw new FileNotFoundException(file.getAbsolutePath());
        }
        if (file.canWrite()) {
            return new PropertyFeatureStore(entry, Query.ALL);
        }
        return new PropertyFeatureSource(entry, Query.ALL);
    }

    @Override
    public void removeSchema(Name typeName) throws IOException {
        this.removeSchema(typeName.getLocalPart());
    }

    @Override
    public void removeSchema(String typeName) throws IOException {
        File file;
        if (!typeName.endsWith(".properties")) {
            typeName = typeName + ".properties";
        }
        if (!(file = new File(this.dir, typeName)).exists()) {
            throw new IOException("Can't delete " + file.getAbsolutePath() + " because it doesn't exist!");
        }
        file.delete();
    }
}

