/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.gdalframework;

import it.geosolutions.imageio.core.CoreCommonImageMetadata;
import it.geosolutions.imageio.gdalframework.GDALUtilities;
import it.geosolutions.imageio.gdalframework.GDALWritableCommonIIOImageMetadata;
import java.awt.Dimension;
import java.awt.image.BandedSampleModel;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.SampleModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.metadata.IIOInvalidTreeException;
import org.gdal.gdal.Dataset;
import org.gdal.gdal.Driver;
import org.gdal.gdal.GCP;
import org.gdal.gdal.gdal;
import org.gdal.gdalconst.gdalconst;
import org.gdal.gdalconst.gdalconstConstants;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GDALCommonIIOImageMetadata
extends CoreCommonImageMetadata {
    private static final Logger LOGGER = Logger.getLogger(GDALCommonIIOImageMetadata.class.toString());
    Map<String, Map<String, String>> gdalDomainMetadataMap;

    public GDALCommonIIOImageMetadata(String sDatasetName) {
        this(sDatasetName, "it_geosolutions_imageio_core_commonImageMetadata_1.0", "it.geosolutions.imageio.core.CommonImageMetadataFormat");
    }

    public GDALCommonIIOImageMetadata(String sDatasetName, String formatName, String formatClassName) {
        this(GDALUtilities.acquireDataSet(sDatasetName, gdalconst.GA_ReadOnly), sDatasetName, formatName, formatClassName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GDALCommonIIOImageMetadata(Dataset dataset, String name, boolean initializationRequired, String formatName, String formatClassName) {
        Throwable e22;
        block17: {
            super(false, formatName, formatClassName, null, null);
            this.setDatasetName(name);
            if (dataset == null) {
                return;
            }
            this.setDatasetDescription(dataset.GetDescription());
            Driver driver = null;
            try {
                Hashtable imageStMap;
                driver = dataset.GetDriver();
                if (driver != null) {
                    this.setDriverDescription(driver.GetDescription());
                    this.setDriverName(driver.getShortName());
                }
                this.gdalDomainMetadataMap = new HashMap<String, Map<String, String>>();
                Hashtable defMap = dataset.GetMetadata_Dict("");
                if (defMap != null && defMap.size() > 0) {
                    this.gdalDomainMetadataMap.put("DEF", defMap);
                }
                if ((imageStMap = dataset.GetMetadata_Dict("IMAGE_STRUCTURE")) != null && imageStMap.size() > 0) {
                    this.gdalDomainMetadataMap.put("IMAGE_STRUCTURE", imageStMap);
                }
                if (initializationRequired) {
                    this.setMembers(dataset);
                }
                this.setGeoreferencingInfo(dataset);
                Object var10_9 = null;
                if (driver == null) break block17;
            }
            catch (Throwable throwable) {
                block19: {
                    Throwable e22;
                    block18: {
                        Object var10_10 = null;
                        if (driver != null) {
                            try {
                                driver.delete();
                            }
                            catch (Throwable e22) {
                                if (!LOGGER.isLoggable(Level.FINEST)) break block18;
                                LOGGER.log(Level.FINEST, e22.getLocalizedMessage(), e22);
                            }
                        }
                    }
                    if (initializationRequired && dataset != null) {
                        try {
                            GDALUtilities.closeDataSet(dataset);
                        }
                        catch (Throwable e22) {
                            if (!LOGGER.isLoggable(Level.FINEST)) break block19;
                            LOGGER.log(Level.FINEST, e22.getLocalizedMessage(), e22);
                        }
                    }
                }
                throw throwable;
            }
            try {
                driver.delete();
            }
            catch (Throwable e22) {
                if (!LOGGER.isLoggable(Level.FINEST)) break block17;
                LOGGER.log(Level.FINEST, e22.getLocalizedMessage(), e22);
            }
        }
        if (initializationRequired && dataset != null) {
            try {
                GDALUtilities.closeDataSet(dataset);
            }
            catch (Throwable e22) {
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.log(Level.FINEST, e22.getLocalizedMessage(), e22);
                }
            }
        }
    }

    public GDALCommonIIOImageMetadata(Dataset dataset, String name, String formatName, String formatClassName) {
        this(dataset, name, true, formatName, formatClassName);
    }

    public GDALCommonIIOImageMetadata(Dataset dataset, String name, boolean initializationRequired) {
        this(dataset, name, initializationRequired, "it_geosolutions_imageio_core_commonImageMetadata_1.0", "it.geosolutions.imageio.core.CommonImageMetadataFormat");
    }

    private void setGeoreferencingInfo(Dataset dataset) {
        double[] geoT = new double[6];
        dataset.GetGeoTransform(geoT);
        this.setGeoTransformation(geoT);
        this.setProjection(dataset.GetProjection());
        this.setGcpProjection(dataset.GetGCPProjection());
        this.setGcpNumber(dataset.GetGCPCount());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private boolean setMembers(Dataset dataset) {
        block46: {
            block47: {
                block44: {
                    block42: {
                        block43: {
                            block39: {
                                block40: {
                                    this.setWidth(dataset.getRasterXSize());
                                    this.setHeight(dataset.getRasterYSize());
                                    xBlockSize = new int[1];
                                    yBlockSize = new int[1];
                                    rband = null;
                                    rband = dataset.GetRasterBand(1);
                                    rband.GetBlockSize(xBlockSize, yBlockSize);
                                    tileHeight = yBlockSize[0];
                                    tileWidth = xBlockSize[0];
                                    this.setTileHeight(tileHeight);
                                    this.setTileWidth(tileWidth);
                                    if ((long)tileHeight * (long)tileWidth > 0x7FFFFFFFL) {
                                        this.performTileSizeTuning(dataset);
                                    }
                                    numBands = dataset.getRasterCount();
                                    this.setNumBands(numBands);
                                    if (numBands > 0) break block39;
                                    var8_8 = false;
                                    var30_10 = null;
                                    if (rband == null) break block40;
                                    try {
                                        rband.delete();
                                    }
                                    catch (Throwable e) {
                                        if (!GDALCommonIIOImageMetadata.LOGGER.isLoggable(Level.FINEST)) break block40;
                                        GDALCommonIIOImageMetadata.LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                                    }
                                }
                                return var8_8;
                            }
                            try {
                                tileSize = tileWidth * tileHeight * numBands * (gdal.GetDataTypeSize((int)rband.getDataType()) / 8);
                                banks = new int[numBands];
                                offsetsR = new int[numBands];
                                noDataValues = new Double[numBands];
                                scales = new Double[numBands];
                                offsets = new Double[numBands];
                                minimums = new Double[numBands];
                                maximums = new Double[numBands];
                                numOverviews = new int[numBands];
                                colorInterpretations = new int[numBands];
                                buf_type = 0;
                                pBand = null;
                                tempD = new Double[1];
                                bandsOffset = new int[numBands];
                                for (band = 0; band < numBands; ++band) {
                                    try {
                                        pBand = dataset.GetRasterBand(band + 1);
                                        buf_type = pBand.getDataType();
                                        banks[band] = band;
                                        offsetsR[band] = 0;
                                        pBand.GetNoDataValue(tempD);
                                        noDataValues[band] = tempD[0];
                                        pBand.GetOffset(tempD);
                                        offsets[band] = tempD[0];
                                        pBand.GetScale(tempD);
                                        scales[band] = tempD[0];
                                        pBand.GetMinimum(tempD);
                                        minimums[band] = tempD[0];
                                        pBand.GetMaximum(tempD);
                                        maximums[band] = tempD[0];
                                        colorInterpretations[band] = pBand.GetRasterColorInterpretation();
                                        numOverviews[band] = pBand.GetOverviewCount();
                                        bandsOffset[band] = band;
                                        var24_34 = null;
                                        if (pBand == null) continue;
                                    }
                                    catch (Throwable var23_36) {
                                        block41: {
                                            var24_34 = null;
                                            if (pBand != null) {
                                                try {
                                                    pBand.delete();
                                                }
                                                catch (Throwable e) {
                                                    if (!GDALCommonIIOImageMetadata.LOGGER.isLoggable(Level.FINEST)) break block41;
                                                    GDALCommonIIOImageMetadata.LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                                                }
                                            }
                                        }
                                        throw var23_36;
                                    }
                                    try {
                                        pBand.delete();
                                    }
                                    catch (Throwable e) {
                                        if (!GDALCommonIIOImageMetadata.LOGGER.isLoggable(Level.FINEST)) continue;
                                        GDALCommonIIOImageMetadata.LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                                    }
                                }
                                this.setNoDataValues(noDataValues);
                                this.setScales(scales);
                                this.setOffsets(offsets);
                                this.setMinimums(minimums);
                                this.setMaximums(maximums);
                                this.setNumOverviews(numOverviews);
                                this.setColorInterpretations(colorInterpretations);
                                buffer_type = 0;
                                if (buf_type == gdalconstConstants.GDT_Byte) {
                                    buffer_type = 0;
                                    break block42;
                                }
                                if (buf_type == gdalconstConstants.GDT_UInt16) {
                                    buffer_type = 1;
                                    break block42;
                                }
                                if (buf_type == gdalconstConstants.GDT_Int16) {
                                    buffer_type = 2;
                                    break block42;
                                }
                                if (buf_type == gdalconstConstants.GDT_Int32 || buf_type == gdalconstConstants.GDT_UInt32) {
                                    buffer_type = 3;
                                    break block42;
                                }
                                if (buf_type == gdalconstConstants.GDT_Float32) {
                                    buffer_type = 4;
                                    break block42;
                                }
                                if (buf_type == gdalconstConstants.GDT_Float64) {
                                    buffer_type = 5;
                                    break block42;
                                }
                                var23_37 = false;
                                var30_11 = null;
                                if (rband == null) break block43;
                            }
                            catch (Throwable var29_45) {
                                block48: {
                                    var30_14 = null;
                                    if (rband != null) {
                                        try {
                                            rband.delete();
                                        }
                                        catch (Throwable e) {
                                            if (!GDALCommonIIOImageMetadata.LOGGER.isLoggable(Level.FINEST)) break block48;
                                            GDALCommonIIOImageMetadata.LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                                        }
                                    }
                                }
                                throw var29_45;
                            }
                            try {
                                rband.delete();
                            }
                            catch (Throwable e) {
                                if (!GDALCommonIIOImageMetadata.LOGGER.isLoggable(Level.FINEST)) break block43;
                                GDALCommonIIOImageMetadata.LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                            }
                        }
                        return var23_37;
                    }
                    if (tileSize < 0) {
                        this.setSampleModel(new BandedSampleModel(buffer_type, tileWidth, tileHeight, tileWidth, banks, offsetsR));
                    } else {
                        this.setSampleModel(new PixelInterleavedSampleModel(buffer_type, tileWidth, tileHeight, numBands, tileWidth * numBands, bandsOffset));
                    }
                    if (colorInterpretations[0] == gdalconstConstants.GCI_PaletteIndex) {
                        ct = null;
                        try {
                            ct = rband.GetRasterColorTable();
                            icm = ct.getIndexColorModel(gdal.GetDataTypeSize((int)buf_type));
                            this.setColorModel(icm);
                            var27_40 = null;
                            ** if (ct == null) goto lbl-1000
                        }
                        catch (Throwable var26_44) {
                            block45: {
                                var27_41 = null;
                                if (ct != null) {
                                    try {
                                        ct.delete();
                                    }
                                    catch (Throwable e) {
                                        if (!GDALCommonIIOImageMetadata.LOGGER.isLoggable(Level.FINEST)) break block45;
                                        GDALCommonIIOImageMetadata.LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                                    }
                                }
                            }
                            throw var26_44;
                        }
lbl-1000:
                        // 1 sources

                        {
                            try {
                                ct.delete();
                            }
                            catch (Throwable e) {
                                if (GDALCommonIIOImageMetadata.LOGGER.isLoggable(Level.FINEST)) {
                                    GDALCommonIIOImageMetadata.LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                                }
                            }
                        }
lbl-1000:
                        // 4 sources

                        {
                            break block44;
                        }
                    }
                    this.setColorModel(GDALUtilities.buildColorModel(this.getSampleModel()));
                }
                if (this.getColorModel() != null && this.getSampleModel() != null) break block46;
                var23_39 = false;
                var30_12 = null;
                if (rband == null) break block47;
                try {
                    rband.delete();
                }
                catch (Throwable e) {
                    if (!GDALCommonIIOImageMetadata.LOGGER.isLoggable(Level.FINEST)) break block47;
                    GDALCommonIIOImageMetadata.LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                }
            }
            return var23_39;
        }
        var30_13 = null;
        ** if (rband == null) goto lbl-1000
lbl-1000:
        // 1 sources

        {
            try {
                rband.delete();
            }
            catch (Throwable e) {
                if (GDALCommonIIOImageMetadata.LOGGER.isLoggable(Level.FINEST)) {
                    GDALCommonIIOImageMetadata.LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                }
            }
        }
lbl-1000:
        // 4 sources

        {
        }
        return true;
    }

    public boolean isReadOnly() {
        return true;
    }

    public void mergeTree(String formatName, Node root) throws IIOInvalidTreeException {
        throw new UnsupportedOperationException("mergeTree operation is not allowed");
    }

    public void reset() {
        throw new UnsupportedOperationException("reset operation is not allowed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<it.geosolutions.imageio.core.GCP> getGCPs() {
        if (!super.getGCPs().isEmpty()) return super.getGCPs();
        Dataset ds = null;
        try {
            int nGCP = this.getGcpNumber();
            Vector gcps = new Vector(nGCP);
            ds = GDALUtilities.acquireDataSet(this.getDatasetName(), gdalconst.GA_ReadOnly);
            ds.GetGCPs(gcps);
            if (gcps != null && !gcps.isEmpty()) {
                ArrayList<it.geosolutions.imageio.core.GCP> groundControlPoints = new ArrayList<it.geosolutions.imageio.core.GCP>(nGCP);
                Iterator it = gcps.iterator();
                while (it.hasNext()) {
                    Throwable e2;
                    Object var9_8;
                    GCP gdalGcp = null;
                    try {
                        gdalGcp = (GCP)it.next();
                        it.geosolutions.imageio.core.GCP gcp = new it.geosolutions.imageio.core.GCP();
                        gcp.setId(gdalGcp.getId());
                        gcp.setDescription(gdalGcp.getInfo());
                        gcp.setColumn((int)gdalGcp.getGCPPixel());
                        gcp.setRow((int)gdalGcp.getGCPLine());
                        gcp.setEasting(gdalGcp.getGCPX());
                        gcp.setNorthing(gdalGcp.getGCPY());
                        gcp.setElevation(gdalGcp.getGCPZ());
                        groundControlPoints.add(gcp);
                        var9_8 = null;
                        if (gdalGcp == null) continue;
                    }
                    catch (Throwable throwable) {
                        var9_8 = null;
                        if (gdalGcp == null) throw throwable;
                        try {
                            gdalGcp.delete();
                            throw throwable;
                        }
                        catch (Throwable e2) {
                            if (!LOGGER.isLoggable(Level.FINEST)) throw throwable;
                            LOGGER.log(Level.FINEST, e2.getLocalizedMessage(), e2);
                        }
                        throw throwable;
                    }
                    try {
                        gdalGcp.delete();
                    }
                    catch (Throwable e2) {
                        if (!LOGGER.isLoggable(Level.FINEST)) continue;
                        LOGGER.log(Level.FINEST, e2.getLocalizedMessage(), e2);
                    }
                }
                this.setGcps(groundControlPoints);
            }
            Object var12_11 = null;
            if (ds == null) return super.getGCPs();
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            if (ds == null) throw throwable;
            try {
                GDALUtilities.closeDataSet(ds);
                throw throwable;
            }
            catch (Throwable e) {
                if (!LOGGER.isLoggable(Level.FINEST)) throw throwable;
                LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
            }
            throw throwable;
        }
        try {
            GDALUtilities.closeDataSet(ds);
            return super.getGCPs();
        }
        catch (Throwable e) {
            if (!LOGGER.isLoggable(Level.FINEST)) return super.getGCPs();
            LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
        }
        return super.getGCPs();
    }

    private void performTileSizeTuning(Dataset dataset) {
        int width = dataset.getRasterXSize();
        int height = dataset.getRasterYSize();
        Dimension imageSize = new Dimension(width, height);
        Dimension tileSize = GDALUtilities.toTileSize(imageSize);
        this.setTileHeight(tileSize.height);
        this.setTileWidth(tileSize.width);
    }

    protected Map getGdalMetadataDomain(String metadataDomain) {
        if (metadataDomain.equalsIgnoreCase("")) {
            if (this.gdalDomainMetadataMap.containsKey("DEF")) {
                return this.gdalDomainMetadataMap.get("DEF");
            }
        } else if ((metadataDomain.equalsIgnoreCase("IMAGE_STRUCTURE") || metadataDomain.startsWith("xml:")) && this.gdalDomainMetadataMap.containsKey(metadataDomain)) {
            return this.gdalDomainMetadataMap.get(metadataDomain);
        }
        return null;
    }

    protected List<String> getGdalMetadataDomainsList() {
        Set<String> keys = this.gdalDomainMetadataMap.keySet();
        ArrayList<String> list = null;
        if (keys != null) {
            Iterator<String> keysIt = keys.iterator();
            list = new ArrayList<String>(keys.size());
            while (keysIt.hasNext()) {
                String key = keysIt.next();
                if (key.equals("DEF")) {
                    list.add("");
                    continue;
                }
                list.add(key);
            }
        }
        return list;
    }

    public GDALWritableCommonIIOImageMetadata asWritable() {
        GDALWritableCommonIIOImageMetadata metadata = new GDALWritableCommonIIOImageMetadata(this.getDatasetName());
        metadata.setDatasetDescription(this.getDatasetDescription());
        metadata.setProjection(this.getProjection());
        metadata.setGcpNumber(this.getGcpNumber());
        metadata.setGcpProjection(this.getGcpProjection());
        metadata.setGeoTransformation(this.getGeoTransformation());
        if (this.gdalDomainMetadataMap != null) {
            Map<String, Map<String, String>> inputMap = this.gdalDomainMetadataMap;
            HashMap map = new HashMap(inputMap.size());
            for (String key : inputMap.keySet()) {
                Map<String, String> valuesMap = inputMap.get(key);
                Iterator<String> inKeys = valuesMap.keySet().iterator();
                HashMap<String, String> innerMap = new HashMap<String, String>(valuesMap.size());
                while (inKeys.hasNext()) {
                    String ikey = inKeys.next();
                    String value = valuesMap.get(ikey);
                    innerMap.put(ikey, value);
                }
                map.put(key, innerMap);
            }
            metadata.gdalDomainMetadataMap = map;
        }
        metadata.setWidth(this.getWidth());
        metadata.setHeight(this.getHeight());
        metadata.setTileHeight(this.getTileHeight());
        metadata.setTileWidth(this.getTileWidth());
        metadata.setSampleModel(null);
        SampleModel sm = this.getSampleModel();
        if (sm != null) {
            int smWidth = sm.getWidth();
            int smHeight = sm.getHeight();
            metadata.setSampleModel(sm.createCompatibleSampleModel(smWidth, smHeight));
        }
        metadata.setNumBands(this.getNumBands());
        metadata.setColorModel(null);
        ColorModel cm = this.getColorModel();
        if (cm != null) {
            if (cm instanceof IndexColorModel) {
                IndexColorModel icm = (IndexColorModel)cm;
                int mapSize = icm.getMapSize();
                byte[] r = new byte[mapSize];
                byte[] g = new byte[mapSize];
                byte[] b = new byte[mapSize];
                icm.getBlues(b);
                icm.getReds(r);
                icm.getGreens(g);
                if (icm.hasAlpha()) {
                    byte[] a = new byte[mapSize];
                    icm.getAlphas(a);
                    metadata.setColorModel(new IndexColorModel(icm.getPixelSize(), mapSize, r, g, b, a));
                } else {
                    metadata.setColorModel(new IndexColorModel(icm.getPixelSize(), mapSize, r, g, b));
                }
            } else {
                metadata.setColorModel(GDALUtilities.buildColorModel(metadata.getSampleModel()));
            }
        }
        metadata.setMaximums(this.getMaximums());
        metadata.setMinimums(this.getMinimums());
        metadata.setNoDataValues(this.getNoDataValues());
        metadata.setScales(this.getScales());
        metadata.setOffsets(this.getOffsets());
        metadata.setNumOverviews(this.getNumOverviews());
        metadata.setColorInterpretations(this.getColorInterpretations());
        return metadata;
    }
}

